/***********************************************************
 * $Id$
 *
 * Copyright (C) 2002-2006 ev-i Informationstechnologie GmbH
 *
 * Created: 05.11.2021
 *
 * Author: wpausch/ev-i
 *
 ***********************************************************/

package at.cdes.api.task.dto;

import at.cdes.api.dto.Organisation;
import at.cdes.api.dto.Person;
import at.cdes.api.task.voc.TaskType;

public class Task {
    private Long taskId;
    private Boolean done;

    // Task
    private TaskType taskType;
    private String name;
    private Double beginDate;
    private Double endDate;
    private Integer deltaT;

    // DocumentTask, DocumentVersionTask
    private Long unreleasedDocumentId;
    private Long documentOrReleaseId;
    private String documentOrReleaseName;
    private String documentOrReleaseContent;
    private Double documentOrReleaseEndDate;

    private Long documentVersionId;
    private String documentVersionName;
    private Double documentVersionUploaded;

    private Long objectReleaseId;
    private String objectReleaseCode;
    private String objectReleaseName;

    private Long projectId;
    private String projectCode;
    private String projectName;

    private Long networkId;
    private String networkName;

    private Double contractualDeadline;
    private Integer minDeltaT;
    private Double overallEndDate;
    private Integer urgency;

    private Double reviewDate;
    private Double doneDate;
    private Boolean finishCellFlag;
    private String resultOptionName;
    private String realmName;
    private String realmCode;
    private Long reviewCycleDelay;
    
    private Long positionResultOrgPersonId;
    public Long getPositionResultOrgPersonId() {
        return this.positionResultOrgPersonId;
    }
    public void setPositionResultOrgPersonId(Long positionResultOrgPersonId) {
        this.positionResultOrgPersonId = positionResultOrgPersonId;
    }
    private Long positionResultPersonId;
    private String positionResultPersonGivenName;
    private String positionResultPersonSurName;
    private Long positionResultOrganisationId;
    private String positionResultOrganisationName;

    // Individual task fields
    private Boolean sampleControlReview;
    private Integer taskStatus;
    private Long taskDelay;
    private Double uploadedDate;
    private Long ownTaskOrgPersonId;
    
    private Long plotOrderJobNumber;

    /** If and only if the person at hand is responsible for the task as a deputy,
     *  here the mainParticipantPerson is stored, with a limited set of attributes
     *  (see ReviewTaskJoin in datamodel.xml for that set of attributes).
     */
    private Person mainParticipantPerson;
    private Organisation mainParticipantOrganisation;
    private Person ownParticipantPerson;
    private Organisation ownParticipantOrganisation;
    private Person signerPerson;
    private Organisation signerOrganisation;
    
    private boolean mayDoReviewProtocol;
    private boolean mayDoReviewDetail;
    private boolean mayDoAssignReview;
    private boolean mayDoReview;
    private boolean mayDoUpload;
    private boolean mayDoReUpload;
    private boolean mayDoUploadOriginal;
    private boolean mayDoPlotOrderConfirm;
    private boolean mayDoPlotOrderDelivery;
    private boolean mayDoDelete;

    public Long getTaskId() {
        return this.taskId;
    }
    public Double getUploadedDate() {
        return this.uploadedDate;
    }
    public void setUploadedDate(Double uploadedDate) {
        this.uploadedDate = uploadedDate;
    }
    public Double getDocumentEndDate() {
        return documentOrReleaseEndDate;
    }
    public void setDocumentEndDate(Double documentEndDate) {
        this.documentOrReleaseEndDate = documentEndDate;
    }
    public Long getReviewCycleDelay() {
        return reviewCycleDelay;
    }
    public void setReviewCycleDelay(Long reviewCycleDelay) {
        this.reviewCycleDelay = reviewCycleDelay;
    }
    public Boolean getDone() {
        return done;
    }
    public void setDone(Boolean done) {
        this.done = done;
    }
    public String getResultOptionName() {
        return this.resultOptionName;
    }
    public void setResultOptionName(String resultOptionName) {
        this.resultOptionName = resultOptionName;
    }
    public String getRealmCode() {
        return this.realmCode;
    }
    public void setRealmCode(String realmCode) {
        this.realmCode = realmCode;
    }
    public void setTaskId(Long taskId) {
        this.taskId = taskId;
    }
    public TaskType getTaskType() {
        return this.taskType;
    }
    public void setTaskType(TaskType taskType) {
        this.taskType = taskType;
    }
    public Long getPositionResultPersonId() {
        return this.positionResultPersonId;
    }
    public void setPositionResultPersonId(Long positionResultPersonId) {
        this.positionResultPersonId = positionResultPersonId;
    }
    public String getPositionResultPersonGivenName() {
        return this.positionResultPersonGivenName;
    }
    public void setPositionResultPersonGivenName(String positionResultPersonGivenName) {
        this.positionResultPersonGivenName = positionResultPersonGivenName;
    }
    public String getPositionResultPersonSurName() {
        return this.positionResultPersonSurName;
    }
    public void setPositionResultPersonSurName(String positionResultPersonSurName) {
        this.positionResultPersonSurName = positionResultPersonSurName;
    }
    public Long getPositionResultOrganisationId() {
        return this.positionResultOrganisationId;
    }
    public void setPositionResultOrganisationId(Long positionResultOrganisationId) {
        this.positionResultOrganisationId = positionResultOrganisationId;
    }
    public String getPositionResultOrganisationName() {
        return this.positionResultOrganisationName;
    }
    public void setPositionResultOrganisationName(String positionResultOrganisationName) {
        this.positionResultOrganisationName = positionResultOrganisationName;
    }
    public String getName() {
        return this.name;
    }
    public void setName(String name) {
        this.name = name;
    }
    public Double getBeginDate() {
        return this.beginDate;
    }
    public void setBeginDate(Double beginDate) {
        this.beginDate = beginDate;
    }
    public Double getEndDate() {
        return this.endDate;
    }
    public void setEndDate(Double endDate) {
        this.endDate = endDate;
    }
    public Integer getDeltaT() {
        return this.deltaT;
    }
    public void setDeltaT(Integer deltaT) {
        this.deltaT = deltaT;
    }
    public Long getDocumentId() {
        return this.documentOrReleaseId;
    }
    public void setDocumentId(Long documentId) {
        this.documentOrReleaseId = documentId;
    }
    public String getDocumentName() {
        return this.documentOrReleaseName;
    }
    public void setDocumentName(String documentName) {
        this.documentOrReleaseName = documentName;
    }
    public String getDocumentContent() {
        return this.documentOrReleaseContent;
    }
    public void setDocumentContent(String documentContent) {
        this.documentOrReleaseContent = documentContent;
    }
    public Long getDocumentVersionId() {
        return this.documentVersionId;
    }
    public void setDocumentVersionId(Long documentVersionId) {
        this.documentVersionId = documentVersionId;
    }
    public String getDocumentVersionName() {
        return this.documentVersionName;
    }
    public void setDocumentVersionName(String documentVersionName) {
        this.documentVersionName = documentVersionName;
    }
    public Double getDocumentVersionUploaded() {
        return this.documentVersionUploaded;
    }
    public void setDocumentVersionUploaded(Double documentVersionUploaded) {
        this.documentVersionUploaded = documentVersionUploaded;
    }
    public Long getObjectId() {
        return this.objectReleaseId;
    }
    public void setObjectId(Long objectId) {
        this.objectReleaseId = objectId;
    }
    public String getObjectCode() {
        return this.objectReleaseCode;
    }
    public void setObjectCode(String objectCode) {
        this.objectReleaseCode = objectCode;
    }
    public String getObjectName() {
        return this.objectReleaseName;
    }
    public void setObjectName(String objectName) {
        this.objectReleaseName = objectName;
    }
    public Long getProjectId() {
        return this.projectId;
    }
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectCode() {
        return this.projectCode;
    }
    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectName() {
        return this.projectName;
    }
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getNetworkId() {
        return networkId;
    }
    public void setNetworkId(Long networkId) {
        this.networkId = networkId;
    }
    public String getNetworkName() {
        return networkName;
    }
    public void setNetworkName(String networkName) {
        this.networkName = networkName;
    }
    public Double getContractualDeadline() {
        return this.contractualDeadline;
    }
    public void setContractualDeadline(Double contractualDeadline) {
        this.contractualDeadline = contractualDeadline;
    }
    public Integer getMinDeltaT() {
        return this.minDeltaT;
    }
    public void setMinDeltaT(Integer minDeltaT) {
        this.minDeltaT = minDeltaT;
    }
    public Double getOverallEndDate() {
        return this.overallEndDate;
    }
    public void setOverallEndDate(Double overallEndDate) {
        this.overallEndDate = overallEndDate;
    }
    public Integer getUrgency() {
        return this.urgency;
    }
    public void setUrgency(Integer urgency) {
        this.urgency = urgency;
    }
    public Boolean getSampleControlReview() {
        return this.sampleControlReview;
    }
    public void setSampleControlReview(Boolean sampleControlReview) {
        this.sampleControlReview = sampleControlReview;
    }
    public Integer getTaskStatus() {
        return this.taskStatus;
    }
    public void setTaskStatus(Integer taskStatus) {
        this.taskStatus = taskStatus;
    }
    public Person getMainParticipantPerson() {
        return this.mainParticipantPerson;
    }
    public void setMainParticipantPerson(Person mainParticipantPerson) {
        this.mainParticipantPerson = mainParticipantPerson;
    }
    public Long getTaskDelay() {
        return this.taskDelay;
    }
    public void setTaskDelay(Long taskDelay) {
        this.taskDelay = taskDelay;
    }
    public Double getReviewDate() {
        return reviewDate;
    }
    public void setReviewDate(Double reviewDate) {
        this.reviewDate = reviewDate;
    }
    public Double getDoneDate() {
        return doneDate;
    }
    public void setDoneDate(Double doneDate) {
        this.doneDate = doneDate;
    }
    public Boolean getFinishCellFlag() {
        return finishCellFlag;
    }
    public void setFinishCellFlag(Boolean finishCellFlag) {
        this.finishCellFlag = finishCellFlag;
    }
    public String getRealmName() {
        return realmName;
    }
    public void setRealmName(String realmName) {
        this.realmName = realmName;
    }
    public Long getOwnTaskOrgPersonId() {
        return this.ownTaskOrgPersonId;
    }
    public void setOwnTaskOrgPersonId(Long ownTaskOrgPersonId) {
        this.ownTaskOrgPersonId = ownTaskOrgPersonId;
    }
    public Long getPlotOrderJobNumber() {
        return this.plotOrderJobNumber;
    }
    public void setPlotOrderJobNumber(Long plotOrderJobNumber) {
        this.plotOrderJobNumber = plotOrderJobNumber;
    }
    public Long getUnreleasedDocumentId() {
        return unreleasedDocumentId;
    }
    public void setUnreleasedDocumentId(Long unreleasedDocumentId) {
        this.unreleasedDocumentId = unreleasedDocumentId;
    }
    public Organisation getMainParticipantOrganisation() {
        return mainParticipantOrganisation;
    }
    public void setMainParticipantOrganisation(Organisation mainParticipantOrganisation) {
        this.mainParticipantOrganisation = mainParticipantOrganisation;
    }
    public Long getDocumentOrReleaseId() {
        return this.documentOrReleaseId;
    }
    public void setDocumentOrReleaseId(Long documentOrReleaseId) {
        this.documentOrReleaseId = documentOrReleaseId;
    }
    public String getDocumentOrReleaseName() {
        return this.documentOrReleaseName;
    }
    public void setDocumentOrReleaseName(String documentOrReleaseName) {
        this.documentOrReleaseName = documentOrReleaseName;
    }
    public String getDocumentOrReleaseContent() {
        return this.documentOrReleaseContent;
    }
    public void setDocumentOrReleaseContent(String documentOrReleaseContent) {
        this.documentOrReleaseContent = documentOrReleaseContent;
    }
    public Double getDocumentOrReleaseEndDate() {
        return this.documentOrReleaseEndDate;
    }
    public void setDocumentOrReleaseEndDate(Double documentOrReleaseEndDate) {
        this.documentOrReleaseEndDate = documentOrReleaseEndDate;
    }
    public Long getObjectReleaseId() {
        return this.objectReleaseId;
    }
    public void setObjectReleaseId(Long objectReleaseId) {
        this.objectReleaseId = objectReleaseId;
    }
    public String getObjectReleaseCode() {
        return this.objectReleaseCode;
    }
    public void setObjectReleaseCode(String objectReleaseCode) {
        this.objectReleaseCode = objectReleaseCode;
    }
    public String getObjectReleaseName() {
        return this.objectReleaseName;
    }
    public void setObjectReleaseName(String objectReleaseName) {
        this.objectReleaseName = objectReleaseName;
    }
    public boolean isMayDoReviewProtocol() {
        return this.mayDoReviewProtocol;
    }
    public void setMayDoReviewProtocol(boolean mayDoReviewProtocol) {
        this.mayDoReviewProtocol = mayDoReviewProtocol;
    }
    public boolean isMayDoReviewDetail() {
        return this.mayDoReviewDetail;
    }
    public void setMayDoReviewDetail(boolean mayDoReviewDetail) {
        this.mayDoReviewDetail = mayDoReviewDetail;
    }
    public boolean isMayDoAssignReview() {
        return this.mayDoAssignReview;
    }
    public void setMayDoAssignReview(boolean mayDoAssignReview) {
        this.mayDoAssignReview = mayDoAssignReview;
    }
    public boolean isMayDoReview() {
        return this.mayDoReview;
    }
    public void setMayDoReview(boolean mayDoReview) {
        this.mayDoReview = mayDoReview;
    }
    public boolean isMayDoUpload() {
        return this.mayDoUpload;
    }
    public void setMayDoUpload(boolean mayDoUpload) {
        this.mayDoUpload = mayDoUpload;
    }
    public boolean isMayDoReUpload() {
        return this.mayDoReUpload;
    }
    public void setMayDoReUpload(boolean mayDoReUpload) {
        this.mayDoReUpload = mayDoReUpload;
    }
    public boolean isMayDoUploadOriginal() {
        return this.mayDoUploadOriginal;
    }
    public void setMayDoUploadOriginal(boolean mayDoUploadOriginal) {
        this.mayDoUploadOriginal = mayDoUploadOriginal;
    }
    public boolean isMayDoPlotOrderConfirm() {
        return this.mayDoPlotOrderConfirm;
    }
    public void setMayDoPlotOrderConfirm(boolean mayDoPlotOrderConfirm) {
        this.mayDoPlotOrderConfirm = mayDoPlotOrderConfirm;
    }
    public boolean isMayDoPlotOrderDelivery() {
        return this.mayDoPlotOrderDelivery;
    }
    public void setMayDoPlotOrderDelivery(boolean mayDoPlotOrderDelivery) {
        this.mayDoPlotOrderDelivery = mayDoPlotOrderDelivery;
    }
    public boolean isMayDoDelete() {
        return this.mayDoDelete;
    }
    public void setMayDoDelete(boolean mayDoDelete) {
        this.mayDoDelete = mayDoDelete;
    }
    public Person getOwnParticipantPerson() {
        return this.ownParticipantPerson;
    }
    public void setOwnParticipantPerson(Person ownParticipantPerson) {
        this.ownParticipantPerson = ownParticipantPerson;
    }
    public Organisation getOwnParticipantOrganisation() {
        return this.ownParticipantOrganisation;
    }
    public void setOwnParticipantOrganisation(Organisation ownParticipantOrganisation) {
        this.ownParticipantOrganisation = ownParticipantOrganisation;
    }
    public Person getSignerPerson() {
        return this.signerPerson;
    }
    public void setSignerPerson(Person signerPerson) {
        this.signerPerson = signerPerson;
    }
    public Organisation getSignerOrganisation() {
        return this.signerOrganisation;
    }
    public void setSignerOrganisation(Organisation signerOrganisation) {
        this.signerOrganisation = signerOrganisation;
    }
}
