/***********************************************************
 * $Id$
 * 
 * Copyright (C) 2002-2006 ev-i Informationstechnologie GmbH
 *
 * Created: 22.08.2022
 *
 * Author: wpausch/ev-i
 * 
 ***********************************************************/

package at.cdes.api.document.compositeDto;

import at.cdes.api.dto.Organisation;
import at.cdes.api.dto.Person;
import at.cdes.api.dto.ProjectParticipant;
import at.cdes.api.dto.Realm;
import at.cdes.api.dto.ReviewCyclePositionResult;

public class DocumentListOtherVersionPositionResultInfo {
    
    private ReviewCyclePositionResult positionResult;
    private Realm realm;
    private ProjectParticipant reviewerParticipant;
    private Organisation reviewerOrganisation;
    private Person reviewerPerson;
    private Person reviewerMainPerson;
    private boolean isAttachedTask;
    
    public void setPositionResult(ReviewCyclePositionResult positionResult) {
        this.positionResult = positionResult;
    }
    
    public void setRealm(Realm realm) {
        this.realm = realm;
    }
    
    public void setReviewerParticipant(ProjectParticipant reviewerParticipant) {
        this.reviewerParticipant = reviewerParticipant;
    }

    public void setReviewerOrganisation(Organisation reviewerOrganisation) {
        this.reviewerOrganisation = reviewerOrganisation;
    }

    public void setReviewerPerson(Person reviewerPerson) {
        this.reviewerPerson = reviewerPerson;
    }

    public void setReviewerMainPerson(Person reviewerMainPerson) {
        this.reviewerMainPerson = reviewerMainPerson;
    }

    public void setAttachedTask(boolean isAttachedTask) {
        this.isAttachedTask = isAttachedTask;
    }
    
    public String getComment() {
        return this.positionResult.getComment();
    }
    
    public Long getRealmId() {
        return this.positionResult.getRealmId();
    }    
    
    public String getRealmName() {
        return this.realm != null && this.realm.getId() != null ? this.realm.getName() : null;
    }

    public Long getResultOptionId() {
        return this.positionResult.getReviewCycleResultOptionId();
    }
    
    public Double getPositionResultResultDate() {
        return this.positionResult.getResultDate();
    }
    
    public Long getParticipationId() {
        return this.reviewerParticipant.getParticipationId();
    }
    
    public boolean hasSignatureId() {
        return this.getSignatureId() != null;
    }
    
    public Long getSignatureId() {
        return this.positionResult.getSignatureId();
    }
    
    public Long getCommentReferenceId() {
        return this.positionResult.getCommentReferenceId();
    }
    
    public Long getNodeId() {
        return this.positionResult.getReviewCycleNodeId();
    }
    
    public boolean isReviewerMainParticipant() {
        return this.reviewerParticipant.getMainParticipantFlag() != null
                && this.reviewerParticipant.getMainParticipantFlag().booleanValue();
    }
    
    public String getReviewerOrganisationName() {
        return this.reviewerOrganisation.getName();
    }
    
    public String getReviewerPersonGivenName() {
        return this.reviewerPerson.getGivenName();
    }
    
    public String getReviewerPersonSurName() {
        return this.reviewerPerson.getSurName();
    }
    
    public String getReviewerMainPersonGivenName() {
        return this.reviewerMainPerson.getGivenName();
    }
    
    public String getReviewerMainPersonSurName() {
        return this.reviewerMainPerson.getSurName();
    }
    
    public boolean isForAttachedTask() {
        return this.isAttachedTask;
    }
}
