/***********************************************************
 * $Id$
 * 
 * Copyright (C) 2002-2006 ev-i Informationstechnologie GmbH
 *
 * Created: 22.08.2022
 *
 * Author: wpausch/ev-i
 * 
 ***********************************************************/

package at.cdes.api.review.compositeDto;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;

import at.cdes.api.dto.ReviewCycleCell;
import at.cdes.api.dto.ReviewCycleCellInstanceReleased;


public class ReviewCycleCellInstanceReleasedInfo {

    private ReviewCycleCell cell;
    
    private ReviewCycleCellInstanceReleased cellInstanceReleased;
    
    // TODO sorted by position ASC
    private List<ReviewCycleNodeInstanceReleasedInfo> nodeInstanceReleasedInfos;
    
    public void setReviewCycleCell(ReviewCycleCell cell) {
        this.cell = cell;
    }
    
    public void setReviewCycleCellInstanceReleased(ReviewCycleCellInstanceReleased cellInstanceReleased) {
        this.cellInstanceReleased = cellInstanceReleased;
    }
    
    public void setNodeInstanceReleasedInfos(List<ReviewCycleNodeInstanceReleasedInfo> nodeInstanceReleasedInfos) {
        this.nodeInstanceReleasedInfos = nodeInstanceReleasedInfos;
        
        Collections.sort(this.nodeInstanceReleasedInfos, new Comparator<ReviewCycleNodeInstanceReleasedInfo>() {
            public int compare(ReviewCycleNodeInstanceReleasedInfo o1, ReviewCycleNodeInstanceReleasedInfo o2) {
                Integer positionOne = o1.getNodePosition();
                Integer positionTwo = o2.getNodePosition();
                return positionOne - positionTwo;
            }
        });        
    }
    
    public ReviewCycleNodeInstanceReleasedInfo getNodeInstanceReleasedInfoByNodeId(Long nodeId) {
        for (ReviewCycleNodeInstanceReleasedInfo nodeInstanceReleasedInfo : nodeInstanceReleasedInfos) {
            if (nodeInstanceReleasedInfo.getNodeId().longValue() == nodeId.longValue()) {
                return nodeInstanceReleasedInfo;
            }
        }
        return null;
    }
    
    public ReviewCycleNodeInstanceReleasedInfo getLastNodeInstanceReleasedInfo() {
        return this.nodeInstanceReleasedInfos.size() > 0 ? this.nodeInstanceReleasedInfos.get(this.nodeInstanceReleasedInfos.size() - 1) : null;
    }
    
    public List<ReviewCycleNodeInstanceReleasedInfo> getAllNodeInstanceReleasedInfos() {
        return this.nodeInstanceReleasedInfos;
    }
    
    public Long getCellInstanceReleasedId() {
        return this.cellInstanceReleased.getId();
    }
    
    public Long getCellInstanceReleasedCellInstanceId() {
        return this.cellInstanceReleased.getReviewCycleCellInstanceId();                
    }
    
    public Long getCellId() {
        return this.cell.getId();
    }
    
    public String getCellName() {
        return this.cell.getName();        
    }
    
    public String getCellSvgColor() {
        return this.cell.getSvgColor();
    }
    
    public boolean isEndCell() {
        return this.cell.getIsEndCell() != null && this.cell.getIsEndCell().booleanValue();
    }    
    
    public Integer getCellPosition() {
        return this.cell.getPosition();
    }
}
