/***********************************************************
 * $Id$
 * 
 * Copyright (C) 2002-2006 ev-i Informationstechnologie GmbH
 *
 * Created: 10.03.2015
 *
 * Author: wpausch/ev-i
 * 
 ***********************************************************/

package at.cdes.api.result;

import java.util.HashMap;
import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import at.cdes.api.voc.EntityVoc;

public class ResultSummary {
    
    private static final Logger log = LoggerFactory.getLogger(ResultSummary.class);

    private Map<EntityVoc, Integer> receivedTuples = new HashMap<EntityVoc, Integer>();
    private Map<String, Integer> receivedJoinComponentTuples = new HashMap<String, Integer>();    
    
    private Map<EntityVoc, Integer> insertedTuples = new HashMap<EntityVoc, Integer>();
    private Map<EntityVoc, Integer> updatedTuples = new HashMap<EntityVoc, Integer>();
    private Map<EntityVoc, Integer> deletedTuples = new HashMap<EntityVoc, Integer>();
    
    public void recordReceivedTuples(EntityVoc entity, int count) {
        if (this.receivedTuples.containsKey(entity)) {
            this.receivedTuples.put(entity, this.receivedTuples.get(entity) + count);
        } else {
            this.receivedTuples.put(entity, count);
        }
    }    
    
    public void recordReceivedJoinComponentTuples(String joinComponent, int count) {
        if (this.receivedJoinComponentTuples.containsKey(joinComponent)) {
            this.receivedJoinComponentTuples.put(joinComponent, this.receivedJoinComponentTuples.get(joinComponent) + count);
        } else {
            this.receivedJoinComponentTuples.put(joinComponent, count);
        }        
    }
    
    public void recordInsertedTuples(EntityVoc entity, int count) {
        if (this.insertedTuples.containsKey(entity)) {
            this.insertedTuples.put(entity, this.insertedTuples.get(entity) + count);
        } else {
            this.insertedTuples.put(entity, count);
        }
    }
    
    public void recordUpdatedTuples(EntityVoc entity, int count) {
        if (this.updatedTuples.containsKey(entity)) {
            this.updatedTuples.put(entity, this.updatedTuples.get(entity) + count);
        } else {
            this.updatedTuples.put(entity, count);
        }
    }
    
    public void recordDeletedTuples(EntityVoc entity, int count) {
        if (this.deletedTuples.containsKey(entity)) {
            this.deletedTuples.put(entity, this.deletedTuples.get(entity) + count);
        } else {
            this.deletedTuples.put(entity, count);
        }
    }    
    
    public void printToLog() {
        this.printToLog(log);
    }
    
    public void printToLog(Logger givenLogger) {
        if (log.isDebugEnabled()) {
            for (EntityVoc entity : this.receivedTuples.keySet()) {
                givenLogger.debug("Received: " + this.receivedTuples.get(entity) + " instances of " + entity);
            }            
            for (String component : this.receivedJoinComponentTuples.keySet()) {
                givenLogger.debug("Received: " + this.receivedJoinComponentTuples.get(component) + " instances of join dto/component " + component);
            }            
            for (EntityVoc entity : this.insertedTuples.keySet()) {
                givenLogger.debug("Inserted: " + this.insertedTuples.get(entity) + " instances of " + entity);
            }
            for (EntityVoc entity : this.updatedTuples.keySet()) {
                givenLogger.debug("Updated: " + this.updatedTuples.get(entity) + " instances of " + entity);
            }
            for (EntityVoc entity : this.deletedTuples.keySet()) {
                givenLogger.debug("Deleted: " + this.deletedTuples.get(entity) + " instances of " + entity);
            }            
        }
    }
}
