/***********************************************************
 * $Id$
 * 
 * Copyright (C) 2002-2006 ev-i Informationstechnologie GmbH
 *
 * Created: 20.02.2022
 *
 * Author: wpausch/ev-i
 * 
 ***********************************************************/

package at.cdes.api.plot.voc;

public enum PlotKindOfDelivery {
    DELIVERY_SERVICE_CONTRACTOR ("Zustelldienst Auftragnehmer"),
    POST ("Post"),
    UPS_PARCEL_SERVICE ("UPS Packetdienst"),
    VELO_EXPRESS ("Velo Express"),
    BY_CUSTOMER ("Selbstabholung");
    
    private final String value;

    private PlotKindOfDelivery(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public static PlotKindOfDelivery getByValue(String value) {
        if (DELIVERY_SERVICE_CONTRACTOR.getValue().equals(value)) {
            return DELIVERY_SERVICE_CONTRACTOR;
        } else if (POST.getValue().equals(value)) {
            return POST;
        } else if (UPS_PARCEL_SERVICE.getValue().equals(value)) {
            return UPS_PARCEL_SERVICE;
        } else if (VELO_EXPRESS.getValue().equals(value)) {
            return VELO_EXPRESS;
        } else if (BY_CUSTOMER.getValue().equals(value)) {
            return BY_CUSTOMER;            
        } else {
            return null;
        }
    }    
}
