/***********************************************************
 * $Id$
 * 
 * Copyright (C) 2002-2006 ev-i Informationstechnologie GmbH
 *
 * Created: 07.11.2017
 *
 * Author: wpausch/ev-i
 * 
 ***********************************************************/

package at.cdes.api.voc;

public enum ReviewCycleStatusSearchDelay {
    
    NO_DELAY (1),
    DELAY (2),
    LONG_DELAY (3);     
    
    private final int value;
    
    private ReviewCycleStatusSearchDelay(int value) {
        this.value = value;
    }
    
    public int getValue() {
        return this.value;
    }
    
    public static ReviewCycleStatusSearchDelay getByValue(Integer value) {
        if (value == null) {
            return null;
        } else if (value.intValue() == NO_DELAY.getValue()) {
            return NO_DELAY;
        } else if (value.intValue() == DELAY.getValue()) {
            return DELAY;
        } else if (value.intValue() == LONG_DELAY.getValue()) {
            return LONG_DELAY;
        } else {
            throw new IllegalArgumentException("Unsupported ReviewCycleStatusSearchDelay value: [" + value + "]");
        }
    }
}
