/***********************************************************
 * $Id$
 * 
 * Copyright (C) 2002-2006 ev-i Informationstechnologie GmbH
 *
 * Created: 05.04.2017
 *
 * Author: wglas/ev-i
 * 
 ***********************************************************/

package at.cdes.api.dto.msp;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

/**
 * An MSP tree item, either an MSP site or an MSP
 */
public class MspItem implements Serializable {

    private static final long serialVersionUID = 7698079772683261031L;

    private MspItemType type;
    private String id;
    private String guid;
    private String title;
    private String icon;
    private String path;
    private String url;
    private String created;
    private String modified;
    private Map<String,String> metaTags;
    
    public MspItemType getType() {
        return this.type;
    }
    public void setType(MspItemType type) {
        this.type = type;
    }
    public String getId() {
        return this.id;
    }
    public void setId(String id) {
        this.id = id;
    }
    public String getGuid() {
        return this.guid;
    }
    public void setGuid(String guid) {
        this.guid = guid;
    }
    public String getTitle() {
        return this.title;
    }
    public void setTitle(String title) {
        this.title = title;
    }
    public String getIcon() {
        return this.icon;
    }
    public void setIcon(String icon) {
        this.icon = icon;
    }
    public String getPath() {
        return this.path;
    }
    public void setPath(String path) {
        this.path = path;
    }
    public String getUrl() {
        return this.url;
    }
    public void setUrl(String url) {
        this.url = url;
    }
    public static long getSerialversionuid() {
        return serialVersionUID;
    }
    public String getCreated() {
        return this.created;
    }
    public void setCreated(String created) {
        this.created = created;
    }
    public String getModified() {
        return this.modified;
    }
    public void setModified(String modified) {
        this.modified = modified;
    }
    public Map<String, String> getMetaTags() {
        return this.metaTags;
    }
    public void setMetaTags(Map<String, String> metaTags) {
        this.metaTags = metaTags;
    }
    public void addMetaTag(String key, String value) {
        
        if (this.metaTags == null) {
            this.metaTags = new HashMap<String,String>();
        }
        this.metaTags.put(key,value);
    }
    @Override
    public String toString() {
        return "MspItem [type=" + this.type + ", id=" + this.id + ", guid="
               + this.guid + ", title=" + this.title + ", icon="
               + this.icon + ", path=" + this.path
               + ", created=" + this.created + ", modified=" + this.modified
               + ", metaTags=" + this.metaTags
               + "]";
    }
}
