/***********************************************************
 * $Id$
 * 
 * Copyright (C) 2002-2006 ev-i Informationstechnologie GmbH
 *
 * Created: 19.02.2017
 *
 * Author: wpausch/ev-i
 * 
 ***********************************************************/

package at.cdes.api.guiService;

import java.util.List;
import java.util.Map;

import org.clazzes.util.lang.Pair;

import at.cdes.api.compositeDto.PlanningNotificationEditInfo;
import at.cdes.api.compositeDto.PlanningNotificationInfo;
import at.cdes.api.compositeDto.PlanningNotificationOrderExtractInfo;
import at.cdes.api.compositeDto.PlanningNotificationOrderImportLine;
import at.cdes.api.compositeDto.PlanningNotificationOrderInfo;
import at.cdes.api.compositeDto.PlanningNotificationOrderSearchInfo;
import at.cdes.api.compositeDto.PlanningNotificationProjectInfo;
import at.cdes.api.compositeDto.PlanningNotificationSaveInfo;
import at.cdes.api.compositeDto.PlanningNotificationSearchInfo;
import at.cdes.api.compositeDto.PlanningNotificationTaskInfo;
import at.cdes.api.compositeDto.PlanningNotificationTemplateInfo;
import at.cdes.api.compositeDto.ReviewSignInfo;
import at.cdes.api.compositeDto.WorkflowActivityResultInfo;
import at.cdes.api.dto.BoundingBox;
import at.cdes.api.dto.MetaTag;
import at.cdes.api.dto.PlanningNotificationOrder;
import at.cdes.api.dto.PlanningNotificationTemplate;
import at.cdes.api.dto.Project;
import at.cdes.api.dto.WorkflowNodePosition;
import at.cdes.api.dto.searchModel.PlanningNotificationOrderSearchModel;
import at.cdes.api.dto.searchModel.PlanningNotificationSearchModel;
import at.cdes.api.dto.searchModel.PlanningReviewProtocolSearchModel;
import at.cdes.api.joinDto.ContextJoin;
import at.cdes.api.joinDto.ProjectJoin;
import at.cdes.api.planning.compositeDto.PlanningNotificationReportExportInfo;
import at.cdes.api.planning.compositeDto.PlanningNotificationReportInfo;
import at.cdes.api.planning.compositeDto.PlanningNotificationTaskCounts;
import at.cdes.api.planning.compositeDto.PlanningNotificationTaskSearchModel;
import at.cdes.api.planning.voc.PlanningNotificationTaskSearchMode;

public interface PlanningNotificationService {
    
    public PlanningNotificationSearchInfo getPlanningNotificationSearchInfo(Long organisationPersonId, Long networkId, boolean includeMetaTags);
    public List<PlanningNotificationInfo> getPlanningNotificationJoins(PlanningNotificationSearchModel searchModel);
    public List<PlanningNotificationReportInfo> getPlanningNotificationReportJoins(PlanningNotificationSearchModel planningNotificationSearchModel,
                                                                             PlanningNotificationOrderSearchModel planningNotificationOrderSearchModel,
                                                                             PlanningReviewProtocolSearchModel reviewProtocolSearchModel,
                                                                             Long baulosMetaTagId);
    
    public PlanningNotificationEditInfo getPlanningNotificationEditInfo(Long organisationPersonId, Long networkId, String... actionNames);
    public PlanningNotificationInfo getPlanningNotificationJoin(Long organisationPersonId, Long planningNotificationId);
    public String saveOrUpdatePlanningNotification(PlanningNotificationSaveInfo saveInfo);
    public void copySharepointFileToCdes(Long organisationPersonId, Long planningNotificationId);
    public void deletePlanningNotification(Long organisationPersonId, Long planningNotificationId);
    
    public PlanningNotificationOrderExtractInfo getBoundingBoxesForPlanningNotificationDocument(Long organisationPersonId, Long planningNotificationId);
    public String extractTextFromPlanningNotificationDocument(Long organisationPersonId, Long planningNotificationId, int page, BoundingBox boundingBox);
    
    public PlanningNotificationOrderSearchInfo getPlanningNotificationReportSearchInfo(Long organisationPersonId, Long networkId);
    public PlanningNotificationOrderSearchInfo getPlanningNotificationOrderSearchInfo(Long organisationPersonId, Long networkId, boolean filterProjects, String... actionNames);
    public PlanningNotificationOrderInfo getPlanningNotificationOrderJoin(Long workflowEntityId, Long organisationPersonId);
    public List<PlanningNotificationOrderInfo> getPlanningNotificationOrderJoins(PlanningNotificationOrderSearchModel searchModel);
    public List<PlanningNotificationOrderInfo> getPlanningNotificationOrderReferenceCandidates(Long organisationPersonId, Long networkId);
    public Long saveOrUpdatePlanningNotificationOrder(Long organisationPersonId, PlanningNotificationOrder planningNotificationOrder, boolean invalidated, 
                                                      List<Long> tagIds, List<Long> newSiteTypeIds, List<Long> referencedWorkflowEntityIds);
    public void deletePlanningNotificationOrder(Long organisationPersonId, Long planningNotificationOrderId);
    public int resetPlanningNotificationWorkflow(Long workflowId, Long organisationPersonId, boolean includingPositions);
    public int deleteWorkflowActivityResult(Long workflowActivityId, Long organisationPersonId);
    public void exportPlanningNotificationOrdersToMsp(Long organisationPersonId, Long networkId, String mspProjectPath, List<Long> workflowEntityIds);
    public void exportPlanningNotificationReportToMsp(Long organisationPersonId, String jobId, String mspDestUrl);
    
    public Map<Long, Project> getReportOptionsInfo(Long organisationPersonId, Long networkId);
    
    /** Creates new WorkflowNodePositions and links them with the given metaInformations.
     *  Afterwards, for each combination of projectParticipationId and metaInformationId given, a WorkflowNodePosition 
     *  with a foreign key to ProjectParticipation, and *one* m:n-mapping to MetaInformation will exist on database.
     *  Thus, if such a WorkflowNodePosition already existed before, no additional instance will be created, instead
     *  (as a hint for the client), a Pair (projectParticipationId, metaInformationId) will be added to the returned
     *  List of Pairs.
     *  
     *  The workflowNodeId, and the new fields dueDate, optionalDueDate, and dueDateRemark, will be taken from the given
     *  newPositionTemplate datastructure.
     * 
     * @param organisationPersonId
     * @param newPositionTemplate
     * @param projectParticipationIds
     * @param metaInformationIds
     * @return Pairs (projectParticipationId, metaInformationId) of workflowNodePositions that already existed before
     */
    public List<Pair<Long,Long>> addWorkflowNodePositions(Long organisationPersonId, WorkflowNodePosition newPositionTemplate, List<Long> projectParticipationIds, List<Long> metaInformationIds);
    public Pair<Long,Long> replaceWorkflowNodePositionsPP(Long organisationPersonId, Long WorkflowNodePositionId, Long projectParticipationId);
    
    public void updateDueDate(Long organisationPersonId, Long workflowNodePositionId, Double dueDate, String dueDateRemark);
    public void updateOptionalDueDate(Long organisationPersonId, Long workflowNodePositionId, Double optionalDueDate);
    public boolean reinitWorkflowNodePosition(Long organisationPersonId, Long workflowNodePositionId);
    public int deleteWorkflowNodePosition(Long organisationPersonId, Long workflowNodePositionId);
    
    public Boolean initializeWorkflow(Long organisationPersonId, Long workflowId);
    
    public List<ContextJoin> getPlanningNotificationTaskInfo(Long organisationPersonId);
    public PlanningNotificationTaskCounts getPlanningNotificationTaskCounts(Long organisationPersonId);
    public List<PlanningNotificationTaskInfo> getPlanningNotificationTaskJoins(PlanningNotificationTaskSearchModel searchModel);
    public WorkflowActivityResultInfo getTaskResultInfo(Long organisationPersonId, Long workflowEntityId);
    public WorkflowActivityResultInfo getTaskResultInfoByWorkflowToken(Long organisationPersonid, Long workflowTokenId, PlanningNotificationTaskSearchMode mode);
    public void reassignWorkflowNodePosition(Long organisationPersonId, Long workflowNodePositionId, Long projectParticipationId);
    public String triggerExportPlanningNotificationTaskList(PlanningNotificationTaskSearchModel searchModel, 
                                                            Map<String, Double> columnToWidth, List<Pair<String, Boolean>> sortColumns);
    
    /** Checks wether the given file size(s) (measured in bytes) are acceptable for uploading
     *  an attachment for a planning notification review.
     * @param fileInfos file names and sizes (measured in bytes) of the uploaded size
     * @return null if the file sizes are all ok, an appropriate error messages if at least one file exceeds the limit
     */
    public String checkPlanningReviewFileSize(List<Pair<String, Long>> fileInfos);
    public List<String> batchSignWorkflowNodePositionResults(List<ReviewSignInfo> reviewSignInfos);
    // Removed on request of ÖBB, still there as private function.
    //    public void dropWorkflowTokenFromBatchSignature(Long organisationPersonId, Long workflowTokenId);
    public void signWorkflowNodePositionResult(ReviewSignInfo reviewSignInfo);
    public void registerWorkflowReviewForLaterSignature(ReviewSignInfo reviewSignInfo);
    
    public PlanningNotificationProjectInfo getPlanningNotificationProjects(Long organisationPersonId, Long networkId);
    public boolean deletePlanningNotificationProject(Long organisationPersonId, Long projectId);
    
    public List<PlanningNotificationTemplate> getAllPlanningNotificationTemplates();
    public PlanningNotificationTemplateInfo getTemplateInfo(Long templateId);
    public PlanningNotificationTemplate createTemplate(PlanningNotificationTemplate template);
    public void updateTemplate(PlanningNotificationTemplate template);
    public boolean deleteTemplate(PlanningNotificationTemplate template);
    
    public List<MetaTag> getAllMetaTags();
    public MetaTag getMetaTag(Long id);
    public MetaTag saveMetaTag(Long planningNotificationTemplateId, MetaTag metaTag);
    public void updateMetaTag(MetaTag metaTag);
    public boolean deleteMetaTag(MetaTag metaTag);
    
    public String triggerExportPlanningNotificationList(PlanningNotificationSearchModel searchModel, Map<String, Double> columnToWidth, List<Pair<String, Boolean>> sortColumns);
    public String triggerExportPlanningNotificationOrderList(PlanningNotificationOrderSearchModel searchModel, Map<String, Double> columnToWidth, List<Pair<String, Boolean>> sortColumns);
    public String triggerExportReviewProtocol(Long organisationPersonId, Long workflowEntityId, 
                                              Map<String, Double> orderColumnToWidth, Map<String, Double> historyColumnToWidth,
                                              List<Pair<String, Boolean>> orderSortSpecs, List<Pair<String, Boolean>> historySortSpecs);
    
    public List<PlanningNotificationOrderImportLine> getPlanningNotificationOrderCsvImportPreview(Long organisationPersonId, Long planningNotificationId, String tempFileName);
    public List<PlanningNotificationOrderImportLine> importPlanningNotificationOrdersFromCsv(Long organisationPersonId, Long planningNotificationId, String tempFileName);
    
    public String triggerExportReport(PlanningNotificationReportExportInfo exportInfo);
}
