/***********************************************************
 * $Id$
 * 
 * Copyright (C) 2002-2006 ev-i Informationstechnologie GmbH
 *
 * Created: 11.11.2014
 *
 * Author: wpausch/ev-i
 * 
 ***********************************************************/

package at.cdes.api.guiService;

import java.util.List;
import java.util.Map;

import at.cdes.api.compositeDto.MasterDataInfo;
import at.cdes.api.compositeDto.PageContext;
import at.cdes.api.compositeDto.VersionInfo;
import at.cdes.api.dto.DocumentType;
import at.cdes.api.dto.Network;
import at.cdes.api.joinDto.DocumentNumberSpecJoinDto;

public interface ContextService {
    public PageContext getPageContext(Long networkId, Long projectId, Long subProjectId, Long pnNetworkId, Long pnProjectId, Long organisationPersonId);
    
    public Network getNetwork(Long networkId);
    
    public List<DocumentNumberSpecJoinDto> getDocumentNumberSpec(Long documentNumberPartGroupId);
    
    public List<DocumentType> getAllDocumentTypes();
    
    public Map<Long, MasterDataInfo> getMasterData(Long networkId);
    
    public VersionInfo getVersionInfo();
    
    public void setPnNetworkIdToPersonVariables(Long networkId);
}
