/***********************************************************
 * $Id$
 * 
 * Copyright (C) 2002-2006 ev-i Informationstechnologie GmbH
 *
 * Created: 22.08.2022
 *
 * Author: wpausch/ev-i
 * 
 ***********************************************************/

package at.cdes.api.review.compositeDto;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import at.cdes.api.dto.ReviewCycleInstanceReleased;

public class ReviewCycleInstanceReleasedInfo {
    
    private ReviewCycleInstanceReleased instanceReleased;
    
    // TODO: Sorted by position ASC
    private List<ReviewCycleCellInstanceReleasedInfo> cellInstanceReleasedInfos;
    
    private Map<Long, ReviewCycleCellInstanceReleasedInfo> cellIdToCellInstanceReleasedInfo;
    
    public void setReviewCycleInstanceReleased(ReviewCycleInstanceReleased instanceReleased) {
        this.instanceReleased = instanceReleased;
    }
    
    public void setCellInstanceReleasedInfos(List<ReviewCycleCellInstanceReleasedInfo> cellInstanceReleasedInfos) {
        this.cellInstanceReleasedInfos = cellInstanceReleasedInfos;
        
        Collections.sort(this.cellInstanceReleasedInfos, new Comparator<ReviewCycleCellInstanceReleasedInfo>() {
            public int compare(ReviewCycleCellInstanceReleasedInfo o1, ReviewCycleCellInstanceReleasedInfo o2) {
                int positionOne = o1.getCellPosition() != null ? o1.getCellPosition() : 0;
                int positionTwo = o2.getCellPosition() != null ? o2.getCellPosition() : 0;
                return positionOne - positionTwo;
            }
        });        
        
        this.cellIdToCellInstanceReleasedInfo = new HashMap<Long, ReviewCycleCellInstanceReleasedInfo>();
        for (ReviewCycleCellInstanceReleasedInfo cellInstanceReleasedInfo : cellInstanceReleasedInfos) {
            Long cellId = cellInstanceReleasedInfo.getCellId();
            this.cellIdToCellInstanceReleasedInfo.put(cellId, cellInstanceReleasedInfo);
        }
    }
    
    public ReviewCycleInstanceReleased getInstanceReleased() {
        return this.instanceReleased;
    }
    
    public List<ReviewCycleCellInstanceReleasedInfo> getAllCellInstanceReleasedInfos() {
        return this.cellInstanceReleasedInfos;
    }
    
    public ReviewCycleCellInstanceReleasedInfo getByCellInstanceReleasedId(Long id) {
        for (ReviewCycleCellInstanceReleasedInfo cellInstanceReleasedInfo : this.cellIdToCellInstanceReleasedInfo.values()) {
            if (cellInstanceReleasedInfo.getCellInstanceReleasedId().longValue() == id.longValue()) {
                return cellInstanceReleasedInfo;
            }
        } 
        return null;        
    }
    
    public ReviewCycleCellInstanceReleasedInfo getByCellId(Long cellId) {
        return this.cellIdToCellInstanceReleasedInfo.get(cellId);
    }
    
    public ReviewCycleCellInstanceReleasedInfo getByCellInstanceId(Long cellInstanceId) {
        for (ReviewCycleCellInstanceReleasedInfo cellInstanceReleasedInfo : this.cellIdToCellInstanceReleasedInfo.values()) {
            if (cellInstanceReleasedInfo.getCellInstanceReleasedCellInstanceId().longValue() == cellInstanceId.longValue()) {
                return cellInstanceReleasedInfo;
            }
        } 
        return null;
    }
    
    public ReviewCycleNodeInstanceReleasedInfo getByNodeId(Long nodeId) {
        for (ReviewCycleCellInstanceReleasedInfo cellInstanceReleasedInfo : cellInstanceReleasedInfos) {
            ReviewCycleNodeInstanceReleasedInfo nodeInstanceReleasedInfo = cellInstanceReleasedInfo.getNodeInstanceReleasedInfoByNodeId(nodeId);
            if (nodeInstanceReleasedInfo != null) {
                return nodeInstanceReleasedInfo;
            }
        }
        return null;
    }
    
    public Long getInstanceReleasedId() {
        return this.instanceReleased.getId();
    }
    
    public String getInstanceReleasedName() {
        return this.instanceReleased.getName();
    }
    
    public Integer getInstanceReleasedDuration() {
        return this.instanceReleased.getDuration();
    }
    
    public Integer getInstanceReleasedDurationMin() {
        return this.instanceReleased.getDurationMin();
    }
    
    public Integer getInstanceReleasedDurationPre() {
        return this.instanceReleased.getDurationPre();
    }

}
