/***********************************************************
 * $Id$
 * 
 * Copyright (C) 2002-2006 ev-i Informationstechnologie GmbH
 *
 * Created: 04.09.2022
 *
 * Author: wpausch/ev-i
 * 
 ***********************************************************/

package at.cdes.api.document.compositeDto;

import at.cdes.api.dto.Realm;
import at.cdes.api.dto.ReviewCycleCellConnectionStatementResult;
import at.cdes.api.dto.ReviewCycleEntryStatementResult;
import at.cdes.api.dto.ReviewCycleResultOption;

public class StatementResultInfo {
    private ReviewCycleCellConnectionStatementResult cellConnectionStatementResult;
    private ReviewCycleEntryStatementResult entryStatementResult;
    private Realm realm;
    private ReviewCycleResultOption resultOption;
    
    public void setCellConnectionStatementResult(ReviewCycleCellConnectionStatementResult cellConnectionStatementResult) {
        this.cellConnectionStatementResult = cellConnectionStatementResult;
    }
    public void setEntryStatementResult(ReviewCycleEntryStatementResult entryStatementResult) {
        this.entryStatementResult = entryStatementResult;
    }
    public void setRealm(Realm realm) {
        this.realm = realm;
    }
    public void setResultOption(ReviewCycleResultOption resultOption) {
        this.resultOption = resultOption;
    }
    
    public String getCellConnectionComment() {
        return this.cellConnectionStatementResult != null ? this.cellConnectionStatementResult.getComment() : null;
    }
    public String getEntryComment() {
        return this.entryStatementResult != null ? this.entryStatementResult.getComment() : null;
    }
    public String getRealmCode() {
        return this.realm != null ? this.realm.getCode() : null;
    }
    public String getRealmName() {
        return this.realm != null ? this.realm.getName() : null;
    }
    public Integer getResultOptionValue() {
        return this.resultOption != null ? this.resultOption.getValue() : null;
    }
    public String getResultOptionName() {
        return this.resultOption != null ? this.resultOption.getName() : null;
    }
    
    

}
