/***********************************************************
 * $Id$
 * 
 * Copyright (C) 2002-2006 ev-i Informationstechnologie GmbH
 *
 * Created: 01.06.2011
 *
 * Author: ahorvath/ev-i
 * 
 ***********************************************************/

package at.cdes.api.document.compositeDto;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArchiveJobStatus implements Serializable {
    private static final long serialVersionUID = -3457291177917986297L;
    
    private int totalFiles;
    private int packedFiles;
    private long archiveFileSize;
    private List<String> errorMessages;
    
    private static final Logger log = LoggerFactory.getLogger(ArchiveJobStatus.class);
    
    public ArchiveJobStatus() {
        this.totalFiles=0;
        this.packedFiles=0;
        this.archiveFileSize=0;
        this.errorMessages = new ArrayList<String>();
    }
    
    public int getTotalFiles() {
        return this.totalFiles;
    }

    public int getPackedFiles() {
        return this.packedFiles;
    }

    public void setPackedFiles(int packedFiles) {
        this.packedFiles = packedFiles;
    }
    
    public void recordFileAddition() {
        this.packedFiles++;
    }

    public void setArchiveFileSize(long archiveFileSize){
        this.archiveFileSize = archiveFileSize;
    }

    public long getArchiveFileSize() {
        return this.archiveFileSize;
    }

    public List<String> getErrorMessages() {
        return this.errorMessages;
    }
    
    public void addErrorMessage(String errorMessage) {
        if (log.isDebugEnabled()) {
            log.debug("Recording error message [" + errorMessage + "]");
        }
        this.errorMessages.add(errorMessage);
    }
}
