/***********************************************************
 * $Id$
 * 
 * Copyright (C) 2002-2006 ev-i Informationstechnologie GmbH
 *
 * Created: 19.07.2017
 *
 * Author: wpausch/ev-i
 * 
 ***********************************************************/

package at.cdes.api.planning.compositeDto;

import java.util.List;
import java.util.Map;

import org.clazzes.util.lang.Pair;

import at.cdes.api.dto.searchModel.PlanningNotificationOrderSearchModel;
import at.cdes.api.dto.searchModel.PlanningNotificationSearchModel;
import at.cdes.api.dto.searchModel.PlanningReviewProtocolSearchModel;
import at.cdes.api.planning.voc.PlanningNotificationReportFileType;
import at.cdes.api.planning.voc.PlanningNotificationReportLayout;
import at.cdes.api.planning.voc.PlanningNotificationReportType;

/** Information necessary for triggering the export of a report.
 *  E.g. selected data, configured options, and so on.
 */
public class PlanningNotificationReportExportInfo {

    private String reportName;
    
    private Long organisationPersonId;
    private Long networkId;
    private PlanningNotificationReportType type;
    private PlanningNotificationReportFileType fileType;
    private String fileName;
    private PlanningNotificationReportLayout layout;
    private Long projectId;
    
    private Integer headerFontSize;
    private Integer dataFontSize;
    private Boolean includeOverallStatusGraphic;
    private Boolean includeOrderStatusGraphics;
    
    private String coverComment;
    private String coverCommentTwo;
    
    private Map<String, Double> columnToWidth;
    
    private PlanningNotificationSearchModel planningNotificationSearchModel;
    
    /** Order search fields --- planningNotificationTitles and projects will not be used, 
     *  they will be fetched from the planningNotificationSearchModel.
     * 
     */
    private PlanningNotificationOrderSearchModel orderSearchModel;
    
    private PlanningReviewProtocolSearchModel reviewSearchModel;
    
    private PlanningNotificationReportColumnSettings columnSettings;
    
    /** Sort specs delivered from the client.  Will only be considered for xls and for pdf-list output. */
    private List<Pair<String, Boolean>> sortSpecs;
    
    public String getReportName() {
        return this.reportName;
    }
    public void setReportName(String reportName) {
        this.reportName = reportName;
    }

    public Long getOrganisationPersonId() {
        return this.organisationPersonId;
    }
    public void setOrganisationPersonId(Long organisationPersonId) {
        this.organisationPersonId = organisationPersonId;
    }
    
    public Long getNetworkId() {
        return this.networkId;
    }
    public void setNetworkId(Long networkId) {
        this.networkId = networkId;
    }
    public PlanningNotificationReportType getType() {
        return this.type;
    }
    public void setType(PlanningNotificationReportType type) {
        this.type = type;
    }

    public PlanningNotificationReportLayout getLayout() {
        return this.layout;
    }
    public void setLayout(PlanningNotificationReportLayout layout) {
        this.layout = layout;
    }
    
    public Long getProjectId() {
        return this.projectId;
    }
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    
    public Integer getHeaderFontSize() {
        return this.headerFontSize;
    }
    public void setHeaderFontSize(Integer headerFontSize) {
        this.headerFontSize = headerFontSize;
    }
    public Integer getDataFontSize() {
        return this.dataFontSize;
    }
    public void setDataFontSize(Integer dataFontSize) {
        this.dataFontSize = dataFontSize;
    }
    
    public Boolean getIncludeOverallStatusGraphic() {
        return this.includeOverallStatusGraphic;
    }
    public void setIncludeOverallStatusGraphic(Boolean includeOverallStatusGraphic) {
        this.includeOverallStatusGraphic = includeOverallStatusGraphic;
    }
    
    public Boolean getIncludeOrderStatusGraphics() {
        return this.includeOrderStatusGraphics;
    }
    public void setIncludeOrderStatusGraphics(Boolean includeOrderStatusGraphics) {
        this.includeOrderStatusGraphics = includeOrderStatusGraphics;
    }
    
    public String getCoverComment() {
        return this.coverComment;
    }
    public void setCoverComment(String coverComment) {
        this.coverComment = coverComment;
    }
    
    public String getCoverCommentTwo() {
        return this.coverCommentTwo;
    }
    public void setCoverCommentTwo(String coverCommentTwo) {
        this.coverCommentTwo = coverCommentTwo;
    }    
    
    public PlanningNotificationSearchModel getPlanningNotificationSearchModel() {
        return this.planningNotificationSearchModel;
    }
    public void setPlanningNotificationSearchModel(PlanningNotificationSearchModel planningNotificationSearchModel) {
        this.planningNotificationSearchModel = planningNotificationSearchModel;
    }
    
    public PlanningNotificationOrderSearchModel getOrderSearchModel() {
        return this.orderSearchModel;
    }
    public void setOrderSearchModel(PlanningNotificationOrderSearchModel orderSearchModel) {
        this.orderSearchModel = orderSearchModel;
    }
    
    public PlanningReviewProtocolSearchModel getReviewSearchModel() {
        return this.reviewSearchModel;
    }
    public void setReviewSearchModel(PlanningReviewProtocolSearchModel reviewSearchModel) {
        this.reviewSearchModel = reviewSearchModel;
    }
    
    public PlanningNotificationReportColumnSettings getColumnSettings() {
        return this.columnSettings;
    }
    public void setColumnSettings(PlanningNotificationReportColumnSettings columnSettings) {
        this.columnSettings = columnSettings;
    }
    public Map<String, Double> getColumnToWidth() {
        return this.columnToWidth;
    }
    public void setColumnToWidth(Map<String, Double> columnToWidth) {
        this.columnToWidth = columnToWidth;
    }
    public List<Pair<String, Boolean>> getSortSpecs() {
        return this.sortSpecs;
    }
    public void setSortSpecs(List<Pair<String, Boolean>> sortSpecs) {
        this.sortSpecs = sortSpecs;
    }
    public PlanningNotificationReportFileType getFileType() {
        return this.fileType;
    }    
    public void setFileType(PlanningNotificationReportFileType fileType) {
        this.fileType = fileType;
    }
    public String getFileName() {
        return this.fileName;
    }
    public void setFileName(String fileName) {
        this.fileName = fileName;
    }
}
