/***********************************************************
 * $Id$
 * 
 * Copyright (C) 2002-2006 ev-i Informationstechnologie GmbH
 *
 * Created: 05.09.2022
 *
 * Author: wpausch/ev-i
 * 
 ***********************************************************/

package at.cdes.api.review.compositeDto;

import at.cdes.api.dto.AttachedReviewCycleNodePosition;
import at.cdes.api.dto.Organisation;
import at.cdes.api.dto.Person;
import at.cdes.api.dto.ProjectParticipant;
import at.cdes.api.dto.Realm;

public class AttachedNodePositionInfo implements INodePositionReleasedInfo {
    private AttachedReviewCycleNodePosition attachedReviewCycleNodePosition;
    private Realm realm;
    private ProjectParticipant reviewerParticipant;
    private Organisation reviewerOrganisation;
    private Person reviewerMainPerson;
    
    public void setAttachedReviewCycleNodePosition(AttachedReviewCycleNodePosition attachedReviewCycleNodePosition) {
        this.attachedReviewCycleNodePosition = attachedReviewCycleNodePosition;
    }
    public void setRealm(Realm realm) {
        this.realm = realm;
    }
    public void setReviewerParticipant(ProjectParticipant reviewerParticipant) {
        this.reviewerParticipant = reviewerParticipant;
    }
    public void setReviewerOrganisation(Organisation reviewerOrganisation) {
        this.reviewerOrganisation = reviewerOrganisation;
    }
    public void setReviewerMainPerson(Person reviewerMainPerson) {
        this.reviewerMainPerson = reviewerMainPerson;
    }
    
    public Long getParticipationId() {
        return this.attachedReviewCycleNodePosition.getProjectParticipationId();        
    }
    
    public Long getRealmId() {
        return this.attachedReviewCycleNodePosition.getRealmId();
    }
    
    public String getRealmName() {
        return this.realm.getName();
    }
    
    public boolean isAttached() {
        return true;
    }    
    
    public boolean isMainParticipant() {
        return this.reviewerParticipant.getMainParticipantFlag() != null 
                && this.reviewerParticipant.getMainParticipantFlag().booleanValue();
    }
    public String getPersonGivenName() {
        return this.reviewerMainPerson.getGivenName();
    }
    public String getPersonSurName() {
        return this.reviewerMainPerson.getSurName();
    }
    public String getOrganisationName() {
        return this.reviewerOrganisation.getName();
    }    
}
