/***********************************************************
 * $Id$
 * 
 * Copyright (C) 2002-2006 ev-i Informationstechnologie GmbH
 *
 * Created: 27.08.2019
 *
 * Author: wpausch/ev-i
 * 
 ***********************************************************/

package at.cdes.api.guiService;

import java.util.List;
import java.util.Map;
import java.util.Set;

import org.clazzes.util.lang.Pair;

import at.cdes.api.dto.Organisation;
import at.cdes.api.joinDto.OrganisationJoin;
import at.cdes.api.joinDto.OrganisationPersonSelectionJoin;
import at.cdes.api.organisation.compositeDto.OrganisationInfo;
import at.cdes.api.organisation.compositeDto.OrganisationSearchInfo;
import at.cdes.api.organisation.searchModel.OrganisationSearchModel;

public interface OrganisationService {
    
    public Organisation getOrganisation(Long organisationId);
    
    public OrganisationSearchInfo getOrganisationSearchInfo(Long organisationPersonId, Long networkId);
    public OrganisationSearchInfo getConsortiumSearchInfo(Long organisationPersonId, Long networkId);
    
    public List<OrganisationInfo> getOrganisationJoins(OrganisationSearchModel searchModel);
    public List<OrganisationInfo> getConsortiumJoins(OrganisationSearchModel searchModel);
    
    public OrganisationInfo getOrganisationCreateInfo(Long organisationPersonId, Long networkId);
    public OrganisationInfo getConsortiumCreateInfo(Long organisationPersonId, Long networkId);    
    public OrganisationInfo getOrganisationEditInfo(Long organisationPersonId, Long organisationId);
    public OrganisationInfo getConsortiumEditInfo(Long organisationPersonId, Long organisationId);   
    
    public List<Organisation> getNetworkOrganisationNames(Long organisationPersonId, Long networkId);
    public List<OrganisationJoin> getNetworkOrganisationJoins(Long organisationPersonId, List<Long> networkIds);
    public List<OrganisationInfo> getNetworkOrganisationInfos(Long organisationPersonId, List<Long> networkIds);
    
    public List<OrganisationPersonSelectionJoin> getOrganisationPersonSelectionJoinsByOrganisation(Long organisationPersonId, Long organisationId);
    public List<OrganisationPersonSelectionJoin> getAllOrganisationPersonSelectionJoins(Long organisationPersonId);
    
    public List<List<String>> getOrganisationInUseHints(Long organisationPersonId, Long organisationId);
    public void deleteOrganisation(Long organisationPersonId, Long organisationId);
    
    public void addOrganisationToNetworks(Long organisationPersonId, Long organisationId, List<Long> networkIds);
    
    public List<OrganisationInfo> getSimilarOrganisations(Long organisationPersonId, Organisation organisation);
    public List<OrganisationInfo> getSimilarConsortiums(Long organisationPersonId, Organisation organisation);
    
    public OrganisationInfo saveOrUpdateOrganisation(Long organisationPersonId, Organisation organisation, Long networkId);
    public OrganisationInfo saveOrUpdateConsortium(Long organisationPersonId, Organisation consortium, Long networkId, Set<Long> memberIds);
    
    public String triggerExportOrganisationList(OrganisationSearchModel searchModel, Map<String, Double> columnToWidth, 
                                                List<Pair<String, Boolean>> sortColumns);  
    public String triggerExportConsortiumList(OrganisationSearchModel searchModel, Map<String, Double> columnToWidth, 
                                              List<Pair<String, Boolean>> sortColumns);    
}
