/***********************************************************
 * $Id$
 * 
 * Copyright (C) 2002-2006 ev-i Informationstechnologie GmbH
 *
 * Created: 25.07.2017
 *
 * Author: wpausch/ev-i
 * 
 ***********************************************************/

package at.cdes.api.planning.compositeDto;

import java.util.List;
import java.util.Map;
import java.util.Set;

import at.cdes.api.compositeDto.PlanningNotificationOrderReferenceInfo;
import at.cdes.api.dto.PlanningNotificationAttachment;
import at.cdes.api.dto.PlanningNotificationDateMetaInformation;
import at.cdes.api.dto.PlanningNotificationOrderTag;
import at.cdes.api.dto.PlanningNotificationTextMetaInformation;
import at.cdes.api.dto.Project;
import at.cdes.api.dto.WorkflowToken;
import at.cdes.api.joinDto.PlanningNotificationReportJoin;
import at.cdes.api.joinDto.WorkflowActivityPositionResultJoin;
import at.cdes.api.joinDto.WorkflowNodeJoin;

public class PlanningNotificationReportInfo {

    private PlanningNotificationReportJoin reportJoin;
    
    public PlanningNotificationReportInfo() {
    }
    
    public PlanningNotificationReportInfo(PlanningNotificationReportJoin reportJoin,
                                          Map<Long, List<PlanningNotificationDateMetaInformation>> metaTagIdToDateMetaInformations,
                                          Map<Long, List<PlanningNotificationTextMetaInformation>> metaTagIdToTextMetaInformations,
                                          List<Long> removableMetaInformationIds,
                                          List<Project> projects,
                                          List<PlanningNotificationOrderReferenceInfo> referenceInfos,
                                          List<PlanningNotificationTextMetaInformation> baulosMetaInformations,
                                          List<PlanningNotificationOrderTag> tags,
                                          List<String> allowedProjectActions,
                                          Boolean workflowInitialized,
                                          List<WorkflowNodeJoin> workflowNodeJoins,
                                          Map<Long, List<WorkflowNodeJoin>> workflowNodeIdToPositions,
                                          Map<Long, List<WorkflowToken>> workflowNodePositionIdToOwnerTokens,
                                          Map<Long, List<PlanningNotificationTextMetaInformation>> workflowNodePositionIdToBaulose,
                                          Map<Long, Boolean> workflowNodeInitiatorPositionIdToHasResults,
                                          List<WorkflowActivityPositionResultJoin> workflowActivityPositionResultJoins,
                                          Map<Long, List<PlanningNotificationTextMetaInformation>> workflowActivityIdToBaulose,
                                          Map<Long, List<PlanningNotificationAttachment>> workflowActivityIdToAttachments,
                                          Set<Long> matchingBaulosIds) {
        this.reportJoin = reportJoin;
        this.metaTagIdToDateMetaInformations = metaTagIdToDateMetaInformations;
        this.metaTagIdToTextMetaInformations = metaTagIdToTextMetaInformations;
        this.removableMetaInformationIds = removableMetaInformationIds;
        this.projects = projects;
        this.referenceInfos = referenceInfos;
        this.baulosMetaInformations = baulosMetaInformations;
        this.tags = tags;
        this.allowedProjectActions = allowedProjectActions;
        this.workflowInitialized = workflowInitialized;
        this.workflowNodeJoins = workflowNodeJoins;
        this.workflowNodeIdToPositions = workflowNodeIdToPositions;
        this.workflowNodePositionIdToOwnerTokens = workflowNodePositionIdToOwnerTokens;
        this.workflowNodePositionIdToBaulose = workflowNodePositionIdToBaulose;
        this.workflowNodeInitiatorPositionIdToHasResults = workflowNodeInitiatorPositionIdToHasResults;
        this.workflowActivityPositionResultJoins = workflowActivityPositionResultJoins;
        this.workflowActivityIdToBaulose = workflowActivityIdToBaulose;
        this.workflowActivityIdToAttachments = workflowActivityIdToAttachments;
        this.matchingBaulosIds = matchingBaulosIds;
    }
    private Map<Long, List<PlanningNotificationDateMetaInformation>> metaTagIdToDateMetaInformations;
    private Map<Long, List<PlanningNotificationTextMetaInformation>> metaTagIdToTextMetaInformations;

    // Not necessary?
    private List<Long> removableMetaInformationIds;
    
    
    private List<Project> projects;
    private List<PlanningNotificationOrderReferenceInfo> referenceInfos;
    private List<PlanningNotificationTextMetaInformation> baulosMetaInformations;
    private List<PlanningNotificationOrderTag> tags;
    private List<String> allowedProjectActions;
    
    
    /** True if and only if in the Workflow corresponding to the orderJoin, at least one WorkflowToken 
     *  connected with WorkflowNodePosition, WorkflowNode and Workflow via ownerPositionId exists.
     *  
     *  Currently only set by 
     *  
     *  at.cdes.impl.service.PlanningNotificationServiceImpl.getPlanningNotificationOrderJoin(Long)
     *  
     *  ... not by the code returning multiple orderJoins for a list.
     */
    private Boolean workflowInitialized;
    
    // Joins contains WorkflowNode and WorkflowNodeTemplate
    private List<WorkflowNodeJoin> workflowNodeJoins;
    
    // Joins contain WorkflowNodePosition, ProjectParticipation, ProjectParticipant, OrganisationPerson, Organisation and Person
    // (but mostly only a few attributes, maybe just the id)
    private Map<Long, List<WorkflowNodeJoin>> workflowNodeIdToPositions;
    
    private Map<Long, List<WorkflowToken>> workflowNodePositionIdToOwnerTokens;
    
    private Map<Long, List<PlanningNotificationTextMetaInformation>> workflowNodePositionIdToBaulose;
    
    private Map<Long, Boolean> workflowNodeInitiatorPositionIdToHasResults;
    
    private List<WorkflowActivityPositionResultJoin> workflowActivityPositionResultJoins;
    private Map<Long, List<PlanningNotificationTextMetaInformation>> workflowActivityIdToBaulose;
    private Map<Long, List<PlanningNotificationAttachment>> workflowActivityIdToAttachments;
    private Set<Long> matchingBaulosIds;

    public PlanningNotificationReportJoin getReportJoin() {
        return this.reportJoin;
    }
    public void setReportJoin(PlanningNotificationReportJoin reportJoin) {
        this.reportJoin = reportJoin;
    }
    public Map<Long, List<PlanningNotificationDateMetaInformation>> getMetaTagIdToDateMetaInformations() {
        return this.metaTagIdToDateMetaInformations;
    }
    public void setMetaTagIdToDateMetaInformations(Map<Long, List<PlanningNotificationDateMetaInformation>> metaTagIdToDateMetaInformations) {
        this.metaTagIdToDateMetaInformations = metaTagIdToDateMetaInformations;
    }
    public Map<Long, List<PlanningNotificationTextMetaInformation>> getMetaTagIdToTextMetaInformations() {
        return this.metaTagIdToTextMetaInformations;
    }
    public void setMetaTagIdToTextMetaInformations(Map<Long, List<PlanningNotificationTextMetaInformation>> metaTagIdToTextMetaInformations) {
        this.metaTagIdToTextMetaInformations = metaTagIdToTextMetaInformations;
    }
    public List<Long> getRemovableMetaInformationIds() {
        return this.removableMetaInformationIds;
    }
    public void setRemovableMetaInformationIds(List<Long> removableMetaInformationIds) {
        this.removableMetaInformationIds = removableMetaInformationIds;
    }
    public List<Project> getProjects() {
        return this.projects;
    }
    public void setProjects(List<Project> projects) {
        this.projects = projects;
    }
    public List<PlanningNotificationOrderReferenceInfo> getReferenceInfos() {
        return this.referenceInfos;
    }
    public void setReferenceInfos(List<PlanningNotificationOrderReferenceInfo> referenceInfos) {
        this.referenceInfos = referenceInfos;
    }
    public List<PlanningNotificationTextMetaInformation> getBaulosMetaInformations() {
        return this.baulosMetaInformations;
    }
    public void setBaulosMetaInformations(List<PlanningNotificationTextMetaInformation> baulosMetaInformations) {
        this.baulosMetaInformations = baulosMetaInformations;
    }
    public List<PlanningNotificationOrderTag> getTags() {
        return this.tags;
    }
    public void setTags(List<PlanningNotificationOrderTag> tags) {
        this.tags = tags;
    }
    public List<String> getAllowedProjectActions() {
        return this.allowedProjectActions;
    }
    public void setAllowedProjectActions(List<String> allowedProjectActions) {
        this.allowedProjectActions = allowedProjectActions;
    }
    
    public Boolean getWorkflowInitialized() {
        return this.workflowInitialized;
    }
    public void setWorkflowInitialized(Boolean workflowInitialized) {
        this.workflowInitialized = workflowInitialized;
    }
    public List<WorkflowNodeJoin> getWorkflowNodeJoins() {
        return this.workflowNodeJoins;
    }
    public void setWorkflowNodeJoins(List<WorkflowNodeJoin> workflowNodeJoins) {
        this.workflowNodeJoins = workflowNodeJoins;
    }
    public Map<Long, List<WorkflowNodeJoin>> getWorkflowNodeIdToPositions() {
        return this.workflowNodeIdToPositions;
    }
    public void setWorkflowNodeIdToPositions(Map<Long, List<WorkflowNodeJoin>> workflowNodeIdToPositions) {
        this.workflowNodeIdToPositions = workflowNodeIdToPositions;
    }
    public Map<Long, List<WorkflowToken>> getWorkflowNodePositionIdToOwnerTokens() {
        return this.workflowNodePositionIdToOwnerTokens;
    }
    public void setWorkflowNodePositionIdToOwnerTokens(Map<Long, List<WorkflowToken>> workflowNodePositionIdToOwnerTokens) {
        this.workflowNodePositionIdToOwnerTokens =
                workflowNodePositionIdToOwnerTokens;
    }
    public Map<Long, List<PlanningNotificationTextMetaInformation>> getWorkflowNodePositionIdToBaulose() {
        return this.workflowNodePositionIdToBaulose;
    }
    public void setWorkflowNodePositionIdToBaulose(Map<Long, List<PlanningNotificationTextMetaInformation>> workflowNodePositionIdToBaulose) {
        this.workflowNodePositionIdToBaulose = workflowNodePositionIdToBaulose;
    }
    public Map<Long, Boolean> getWorkflowNodeInitiatorPositionIdToHasResults() {
        return this.workflowNodeInitiatorPositionIdToHasResults;
    }
    public void setWorkflowNodeInitiatorPositionIdToHasResults(Map<Long, Boolean> workflowNodeInitiatorPositionIdToHasResults) {
        this.workflowNodeInitiatorPositionIdToHasResults =
                workflowNodeInitiatorPositionIdToHasResults;
    }
    public List<WorkflowActivityPositionResultJoin> getWorkflowActivityPositionResultJoins() {
        return this.workflowActivityPositionResultJoins;
    }
    public void setWorkflowActivityPositionResultJoins(List<WorkflowActivityPositionResultJoin> workflowActivityPositionResultJoins) {
        this.workflowActivityPositionResultJoins =
                workflowActivityPositionResultJoins;
    }
    public Map<Long, List<PlanningNotificationTextMetaInformation>> getWorkflowActivityIdToBaulose() {
        return this.workflowActivityIdToBaulose;
    }
    public void setWorkflowActivityIdToBaulose(Map<Long, List<PlanningNotificationTextMetaInformation>> workflowActivityIdToBaulose) {
        this.workflowActivityIdToBaulose = workflowActivityIdToBaulose;
    }
    public Map<Long, List<PlanningNotificationAttachment>> getWorkflowActivityIdToAttachments() {
        return this.workflowActivityIdToAttachments;
    }
    public void setWorkflowActivityIdToAttachments(Map<Long, List<PlanningNotificationAttachment>> workflowActivityIdToAttachments) {
        this.workflowActivityIdToAttachments = workflowActivityIdToAttachments;
    }
    
    public Set<Long> getMatchingBaulosIds() {
        return this.matchingBaulosIds;
    }
    public void setMatchingBaulosIds(Set<Long> matchingBaulosIds) {
        this.matchingBaulosIds = matchingBaulosIds;
    }    
}
