/***********************************************************
 * $Id$
 * 
 * Copyright (C) 2002-2006 ev-i Informationstechnologie GmbH
 *
 * Created: 22.12.2014
 *
 * Author: wpausch/ev-i
 * 
 ***********************************************************/

package at.cdes.api.guiService;

import java.util.List;
import java.util.Set;

import at.cdes.api.dto.Network;
import at.cdes.api.dto.OrderAddress;
import at.cdes.api.dto.PlotOrderSearchModel;
import at.cdes.api.dto.Project;
import at.cdes.api.joinDto.PlotOrderDeleteJoin;
import at.cdes.api.joinDto.PlotOrderEditJoin;
import at.cdes.api.joinDto.PlotOrderJoin;
import at.cdes.api.plot.compositeDto.CreatePlotOrderData;
import at.cdes.api.plot.compositeDto.OrderAddressEditInfo;
import at.cdes.api.plot.compositeDto.PlotOrderSignInfo;
import at.cdes.api.plot.compositeDto.PlotOrderTemplateEditInfo;
import at.cdes.api.plot.compositeDto.PlotOrderTemplateInfo;
import at.cdes.api.plot.compositeDto.PlotOrderTemplatePageInfo;
import at.cdes.api.plot.compositeDto.PlotOrderTemplateSearchModel;
import at.cdes.api.plot.compositeDto.PlotTaskInfo;


public interface PlotService {

    
    public List<PlotOrderJoin> getPlotOrderJoin(Long organisationPersonId, PlotOrderSearchModel searchModel);
    
    public List<PlotOrderJoin> getPlotOrderJoinByIds(Long organisationPersonId, List<Long> plotOrderIds);
    
    public List<PlotOrderEditJoin> getPlotOrderEditJoin(Long plotOrderId, Long organisationPersonId);
    
    public void deletePlotOrder(Long plotOrderId, Long organisationPersonId, Long projectId);
    
    public void deletePlotOrderItem(Long plotOrderItemId, Long organisationPersonId, Long projectId);
    
    public void declarePlotOrdersCharged(Long organisationPersonId, Long projectId, List<Long> plotOrderIds, String password);
    
    public String triggerExportPlotOrdersToPdf(Long organisationPersonId, Network network, Project project, List<PlotOrderJoin> plotOrderJoins, String personVariablesUserLocale);
    public String triggerExportPlotTaskToPdf(Long organisationPersonId, Long taskId, boolean plotOrderAcceptance);
    
    public String triggerExportCompletePlotOrder(Long organisationPersonId, Long projectId, Long plotOrderId, String personVariablesUserLocale);
    
    public String checkAndCreatePlotTask(Long organisationPersonId, Long projectId, Long plotOrderId, String personVariablesUserLocale);
    
    public CreatePlotOrderData getCreateManualPlotOrderData(Long organisationPersonId, Long documentVersionId, PlotOrderTemplateSearchModel searchModel);
    
    public void signPlotOrders(Long organisationPersonId, Long documentVersionId, String comment, String password, List<PlotOrderSignInfo> signInfos);
    
    public PlotOrderTemplatePageInfo getPlotOrderTemplatePageInfo(Long organisationPersonId, Long projectId);
    public PlotOrderTemplateEditInfo getPlotOrderTemplateEditInfo(Long organisationPersonId, Long plotOrderTemplateId, Long projectId);
    public PlotOrderTemplateInfo getPlotOrderTemplateInfoById(Long organisationPersonId, Long plotOrderTemplateId);
    public List<PlotOrderTemplateInfo> getPlotOrderTemplateInfos(Long organisationPersonId, PlotOrderTemplateSearchModel searchModel);
    
    public void saveOrUpdatePlotOrderTemplate(Long organisationPersonId,
                                              PlotOrderTemplateInfo templateInfo);
    public String mayDeletePlotOrderTemplate(Long organisationPersonId, Long plotOrderTemplateId);
    public void invalidatePlotOrderTemplate(Long organisationPersonId, Long plotOrderTemplateId);
    
    public OrderAddressEditInfo getOrderAddressEditInfo(Long organisationPersonId, Long orderAddressId, Long networkId);
    
    public OrderAddress saveOrUpdateOrderAddress(Long organisationPersonId, OrderAddress orderAddress);
    
    public List<PlotOrderDeleteJoin> getPlotOrderDeleteJoinsPreventingSubProjectInvalidate(Long organisationPersonId, Long subProjectId);
    public List<PlotOrderDeleteJoin> getPlotOrderDeleteJoinsPreventingProjectInvalidate(Long organisationPersonId, Long projectId);
    
    public PlotTaskInfo getPlotOrderAcceptanceTaskInfoByPlotOrderId(Long organisationPersonId, Long plotOrderId);
    public PlotTaskInfo getPlotOrderAcceptanceTaskInfo(Long organisationPersonId, Long taskId);
    public PlotTaskInfo getReviewCyclePlotTaskInfo(Long organisationPersonId, Long taskId);
    public void acceptReviewCyclePlotTask(Long organisationPersonId, Long taskId, String comment, String password, boolean ok);
    public void acceptAndCompleteReviewCyclePlotTask(Long organisationPersonId, Long taskId, String comment, String password, boolean ok);
    public void acceptPlotOrderItemTask(Long organisationPersonId, Long taskId, String comment, String password, boolean ok, Set<Long> selectedPlotOrderItemIds);
}