/***********************************************************
 * $Id$
 * 
 * Copyright (C) 2002-2006 ev-i Informationstechnologie GmbH
 *
 * Created: 13.01.2015
 *
 * Author: wpausch/ev-i
 * 
 ***********************************************************/

package at.cdes.api.voc;

public enum DocumentVersionStatus {
    
    INREVIEW (1),
    RELEASEDPOSITIV (2),
    RELEASEDNEGATIV (3),
    INVALIDATEDVERSION (4),
    INVALIDATEDALL (5),
    NOTINREVIEW (6),
    DELETED (7),
    PREREVIEWED (8),
    ACTIVE (9),
    ASBUILT (10),
    NOTUPLOADED (11),
    REPLACED (12),
    ABORTED (13);
    
    private final int value;
    
    private DocumentVersionStatus(int value) {
        this.value = value;
    }
    
    public int getValue() {
        return this.value;
    }
    
    public static DocumentVersionStatus getByValue(Integer value) {
        if (value == null) {
            return null;
        } else if (value == INREVIEW.getValue()) {
            return DocumentVersionStatus.INREVIEW;
        } else if (value == RELEASEDPOSITIV.getValue()) {
            return DocumentVersionStatus.RELEASEDPOSITIV;
        } else if (value == RELEASEDNEGATIV.getValue()) {
            return DocumentVersionStatus.RELEASEDNEGATIV;
        } else if (value == INVALIDATEDVERSION.getValue()) {
            return DocumentVersionStatus.INVALIDATEDVERSION;
        } else if (value == INVALIDATEDALL.getValue()) {
            return DocumentVersionStatus.INVALIDATEDALL;
        } else if (value == NOTINREVIEW.getValue()) {
            return DocumentVersionStatus.NOTINREVIEW;
        } else if (value == DELETED.getValue()) {
            return DocumentVersionStatus.DELETED;
        } else if (value == PREREVIEWED.getValue()) {
            return DocumentVersionStatus.PREREVIEWED;
        } else if (value == ACTIVE.getValue()) {
            return DocumentVersionStatus.ACTIVE;
        } else if (value == ASBUILT.getValue()) {
            return DocumentVersionStatus.ASBUILT;
        } else if (value == NOTUPLOADED.getValue()) {
            return DocumentVersionStatus.NOTUPLOADED;
        } else if (value == REPLACED.getValue()) {
            return DocumentVersionStatus.REPLACED;
        } else if (value == ABORTED.getValue()) {
            return DocumentVersionStatus.ABORTED;
        } else {
            throw new IllegalArgumentException("Unknown DocumentVersionStatusValue [" + value + "] found, please inspect.");
        }
    }
}
