/***********************************************************
 * $Id$
 * 
 * Copyright (C) 2002-2006 ev-i Informationstechnologie GmbH
 *
 * Created: 23.09.2021
 *
 * Author: wpausch/ev-i
 * 
 ***********************************************************/

package at.cdes.api.dto.util;

import java.util.List;
import java.util.Map;

import at.cdes.api.compositeDto.VersionInfo;
import at.cdes.api.dto.InfoMessage;
import at.cdes.api.dto.Network;
import at.cdes.api.dto.Person;
import at.cdes.api.dto.PersonVariables;
import at.cdes.api.dto.Project;
import at.cdes.api.dto.SubProject;
import at.cdes.api.joinDto.OrganisationPersonJoin;

/** Contains information displayed or relevant for the main ui,
 *  i.e. things like main menu, logout button, etc. 
 */
public class MainUiInfo {
    
    private String principal;
    
    /** The login person.
     */
    private Person person;
    
    /** PersonVariables of the login person
     * 
     */
    private PersonVariables personVariables;
    
    /** Joins Organisation/Country/Person/OrganisationPerson for all active OrganisationPersons
     *  of the login Person.  Inactive are organisation persons with invalid flag, or without
     *  valid certificate.
     */
    private List<OrganisationPersonJoin> organisationPersonJoins;
    
    /** All relevant InfoMessages (based on current time on the one hand, and
     *  their interval on the other hand side).
     */
    private List<InfoMessage> infoMessages;
    
    private VersionInfo versionInfo;
    
    /** Organisation person id (as in organisationPersonJoins above) mapped to
     *  networks the OrganisationPerson at hand may set the context to.
     *  Networks are basically determined by the NetworkPerson and NetworkOrganisation
     *  relations.
     */
    private Map<Long, List<Network>> organisationPersonIdToNetworks;
    
    /** Map from network id to projects in the network.
     *  Only projects with project status ACTIVE or 
     *  PLANNING_NOTIFICATION_PROJECT are considered.
     *  
     *  The map doesn't need to be complete, i.e. doesn't
     *  need to contain entries for all networks.
     */
    private Map<Long, List<Project>> networkIdToProjects;

    /** Map from project id to sub projects in the project.
     *  Only not-invalidated sub projects are considered.
     *  
     *  The map doesn't need to be complete, i.e. doesn't
     *  need to contain entries for all projects.
     */
    private Map<Long, List<SubProject>> projectIdToSubProjects;
    
    private Boolean enableCustomerLogo;
    private Boolean certificateAdministrationGlobal;
    private Boolean isTestInstance;
    
    private String externalManualLink;
    
    private Boolean isSuperAdmin;
    private Boolean hasEditPerson;
    private Boolean hasShowPerson;
    private Boolean hasShowOrganisation;
    private Boolean hasShowConsortium;
    private Boolean hasEditProject;
    private Boolean hasGenerateReviewReport;
    
    public Boolean getHasEditPerson() {
        return this.hasEditPerson;
    }

    public void setHasEditPerson(Boolean hasEditPerson) {
        this.hasEditPerson = hasEditPerson;
    }

    public Boolean getHasEditProject() {
        return this.hasEditProject;
    }

    public void setHasEditProject(Boolean hasEditProject) {
        this.hasEditProject = hasEditProject;
    }

    private Boolean mayShowReviewSection;
    private Boolean mayShowAdminMenu;
    private Boolean mayShowBuek;
    private Boolean mayShowNetworkSection;
    
    public String getPrincipal() {
        return this.principal;
    }

    public void setPrincipal(String principal) {
        this.principal = principal;
    }

    public Person getPerson() {
        return this.person;
    }

    public void setPerson(Person person) {
        this.person = person;
    }

    public PersonVariables getPersonVariables() {
        return this.personVariables;
    }

    public void setPersonVariables(PersonVariables personVariables) {
        this.personVariables = personVariables;
    }

    public List<OrganisationPersonJoin> getOrganisationPersonJoins() {
        return this.organisationPersonJoins;
    }

    public void setOrganisationPersonJoins(List<OrganisationPersonJoin> organisationPersonJoins) {
        this.organisationPersonJoins = organisationPersonJoins;
    }

    public List<InfoMessage> getInfoMessages() {
        return this.infoMessages;
    }

    public void setInfoMessages(List<InfoMessage> infoMessages) {
        this.infoMessages = infoMessages;
    }

    public Map<Long, List<Network>> getOrganisationPersonIdToNetworks() {
        return this.organisationPersonIdToNetworks;
    }

    public void setOrganisationPersonIdToNetworks(Map<Long, List<Network>> organisationPersonIdToNetworks) {
        this.organisationPersonIdToNetworks = organisationPersonIdToNetworks;
    }

    public Map<Long, List<Project>> getNetworkIdToProjects() {
        return this.networkIdToProjects;
    }

    public void setNetworkIdToProjects(Map<Long, List<Project>> networkIdToProjects) {
        this.networkIdToProjects = networkIdToProjects;
    }

    public Map<Long, List<SubProject>> getProjectIdToSubProjects() {
        return this.projectIdToSubProjects;
    }

    public void setProjectIdToSubProjects(Map<Long, List<SubProject>> projectIdToSubProjects) {
        this.projectIdToSubProjects = projectIdToSubProjects;
    }

    public Boolean getEnableCustomerLogo() {
        return this.enableCustomerLogo;
    }

    public void setEnableCustomerLogo(Boolean enableCustomerLogo) {
        this.enableCustomerLogo = enableCustomerLogo;
    }

    public Boolean getCertificateAdministrationGlobal() {
        return this.certificateAdministrationGlobal;
    }

    public void setCertificateAdministrationGlobal(Boolean certificateAdministrationGlobal) {
        this.certificateAdministrationGlobal = certificateAdministrationGlobal;
    }

    public Boolean getIsTestInstance() {
        return this.isTestInstance;
    }

    public void setIsTestInstance(Boolean isTestInstance) {
        this.isTestInstance = isTestInstance;
    }

    public String getExternalManualLink() {
        return this.externalManualLink;
    }

    public void setExternalManualLink(String externalManualLink) {
        this.externalManualLink = externalManualLink;
    }

    public Boolean getIsSuperAdmin() {
        return this.isSuperAdmin;
    }

    public void setIsSuperAdmin(Boolean isSuperAdmin) {
        this.isSuperAdmin = isSuperAdmin;
    }

    public Boolean getMayShowAdminMenu() {
        return this.mayShowAdminMenu;
    }

    public void setMayShowAdminMenu(Boolean mayShowAdminMenu) {
        this.mayShowAdminMenu = mayShowAdminMenu;
    }

    public Boolean getMayShowReviewSection() {
        return this.mayShowReviewSection;
    }

    public void setMayShowReviewSection(Boolean mayShowReviewSection) {
        this.mayShowReviewSection = mayShowReviewSection;
    }

    public Boolean getMayShowBuek() {
        return this.mayShowBuek;
    }

    public void setMayShowBuek(Boolean mayShowBuek) {
        this.mayShowBuek = mayShowBuek;
    }

    public Boolean getMayShowNetworkSection() {
        return this.mayShowNetworkSection;
    }

    public void setMayShowNetworkSection(Boolean mayShowNetworkSection) {
        this.mayShowNetworkSection = mayShowNetworkSection;
    }

    public Boolean getHasShowPerson() {
        return this.hasShowPerson;
    }

    public void setHasShowPerson(Boolean hasShowPerson) {
        this.hasShowPerson = hasShowPerson;
    }

    public Boolean getHasShowOrganisation() {
        return this.hasShowOrganisation;
    }

    public void setHasShowOrganisation(Boolean hasShowOrganisation) {
        this.hasShowOrganisation = hasShowOrganisation;
    }

    public Boolean getHasShowConsortium() {
        return this.hasShowConsortium;
    }

    public void setHasShowConsortium(Boolean hasShowConsortium) {
        this.hasShowConsortium = hasShowConsortium;
    }

    public Boolean getHasGenerateReviewReport() {
        return this.hasGenerateReviewReport;
    }

    public void setHasGenerateReviewReport(Boolean hasGenerateReviewReport) {
        this.hasGenerateReviewReport = hasGenerateReviewReport;
    }

	public VersionInfo getVersionInfo() {
		return this.versionInfo;
	}

	public void setVersionInfo(VersionInfo versionInfo) {
		this.versionInfo = versionInfo;
	}
}
