/***********************************************************
 * $Id$
 * 
 * Copyright (C) 2002-2006 ev-i Informationstechnologie GmbH
 *
 * Created: 20.02.2022
 *
 * Author: wpausch/ev-i
 * 
 ***********************************************************/

package at.cdes.api.plot.voc;

public enum PlotColor {
    MONOCHROME (0),
    IN_COLOR (1),
    LIKE_TEMPLATE (2);
    
    private final int value;

    private PlotColor(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static PlotColor getByValue(int value) {
        if (MONOCHROME.getValue() == value) {
            return MONOCHROME;
        } else if (IN_COLOR.getValue() == value) {
            return IN_COLOR;
        } else if (LIKE_TEMPLATE.getValue() == value) {
            return LIKE_TEMPLATE;           
        } else {
            return null;
        }
    }    

}
