/***********************************************************
 * $Id$
 * 
 * Copyright (C) 2002-2006 ev-i Informationstechnologie GmbH
 *
 * Created: 21.12.2022
 *
 * Author: wpausch/ev-i
 * 
 ***********************************************************/

package at.cdes.api.obj.voc;

public enum ObjectPlannerPositionDefinitionStatus {
    
    RELEASEDPOSITIV (1),
    RELEASEDNEGATIV (2),
    INVALIDATEDVERSION (3),
    INVALIDATEDALL (4),
    DELETED (5),
    REVISED (6);
    
    private final int value;
    
    private ObjectPlannerPositionDefinitionStatus(int value) {
        this.value = value;
    }
    
    public int getValue() {
        return this.value;
    }
    
    public static ObjectPlannerPositionDefinitionStatus getByValue(Integer value) {
        if (value == null) {
            return null;
        } else if (value == RELEASEDPOSITIV.getValue()) {
            return ObjectPlannerPositionDefinitionStatus.RELEASEDPOSITIV;
        } else if (value == RELEASEDNEGATIV.getValue()) {
            return ObjectPlannerPositionDefinitionStatus.RELEASEDNEGATIV;
        } else if (value == INVALIDATEDVERSION.getValue()) {
            return ObjectPlannerPositionDefinitionStatus.INVALIDATEDVERSION;
        } else if (value == INVALIDATEDALL.getValue()) {
            return ObjectPlannerPositionDefinitionStatus.INVALIDATEDALL;
        } else if (value == DELETED.getValue()) {
            return ObjectPlannerPositionDefinitionStatus.DELETED;
        } else if (value == REVISED.getValue()) {
            return ObjectPlannerPositionDefinitionStatus.REVISED;
        } else {
            throw new IllegalArgumentException("Unknown DocumentVersionStatusValue [" + value + "] found, please inspect.");
        }
    }    

}
