/***********************************************************
 * $Id$
 * 
 * Copyright (C) 2002-2006 ev-i Informationstechnologie GmbH
 *
 * Created: 28.11.2017
 *
 * Author: wpausch/ev-i
 * 
 ***********************************************************/

package at.cdes.api.voc;

public enum ArchiveScope {
    ARCHIVE_SCOPE_RECENT           (1),
    ARCHIVE_SCOPE_ALL              (2),
    ARCHIVE_SCOPE_ALLWITHHISTORY   (3);
    
    private final int value;

    private ArchiveScope(int value) {
        this.value = value;
    }
    
    public int getValue() {
        return this.value;
    }
    
    public static ArchiveScope getByValue(int value) {
        if (value == ARCHIVE_SCOPE_RECENT.getValue()) {
            return ARCHIVE_SCOPE_RECENT;
        } else if (value == ARCHIVE_SCOPE_ALL.getValue()) {
            return ARCHIVE_SCOPE_ALL;
        } else if (value == ARCHIVE_SCOPE_ALLWITHHISTORY.getValue()) {
            return ARCHIVE_SCOPE_ALLWITHHISTORY;
        } else {
            throw new IllegalArgumentException("Unrecognized ArchiveScope value: [" + value + "]");
        }
    }    
}
