/***********************************************************
 * $Id$
 * 
 * Copyright (C) 2002-2006 ev-i Informationstechnologie GmbH
 *
 * Created: 23.05.2018
 *
 * Author: wpausch/ev-i
 * 
 ***********************************************************/

package at.cdes.api.planning.voc;

public enum PlanningNotificationTaskSearchMode {
    
    OWN ("Own"),
    OPEN ("Open"),
    LATE ("Belated"),
    BATCH ("BatchSignatures");
    
    private final String value;
    
    private PlanningNotificationTaskSearchMode(String value) {
        this.value = value;
    }
    
    public String getValue() {
        return this.value;
    }    
    
    public static PlanningNotificationTaskSearchMode getByValue(String value) {
        if (value == OWN.getValue()) {
            return OWN;
        } else if (value == OPEN.getValue()) {
            return OPEN;
        } else if (value == LATE.getValue()) {
            return LATE;
        } else if (value == BATCH.getValue()) {
            return BATCH;            
        } else {
            return null;
        }
    }     

}
