/***********************************************************
 * $Id$
 * 
 * Copyright (C) 2002-2006 ev-i Informationstechnologie GmbH
 *
 * Created: 18.05.2015
 *
 * Author: wpausch/ev-i
 * 
 ***********************************************************/

package at.cdes.api.voc;

public enum PaperFormat {
    
    A0 (2384.0, 3370.0, 841.0, 1189.0),
    A1 (1684.0, 2384.0, 594.0,  841.0),
    A2 (1191.0, 1684.0, 420.0,  594.0),
    A3 ( 842.0, 1191.0, 297.0,  420.0),
    A4 ( 595.0,  842.0, 210.0,  297.0);

    private double ptWidth;
    private double ptHeight;
    private double mmWidth;
    private double mmHeight;
    
    private PaperFormat(double ptWidth, double ptHeight, double mmWidth, double mmHeight) {
        this.ptWidth = ptWidth;
        this.ptHeight = ptHeight;
        this.mmWidth = mmWidth;
        this.mmHeight = mmHeight;
    }
    
    public double getPtWidth() {
        return this.ptWidth;
    }
    
    public double getPtHeight() {
        return this.ptHeight;
    }
    
    public double getMmWidth() {
        return this.mmWidth;
    }
    
    public double getMmHeight() {
        return this.mmHeight;
    }
    
    public static PaperFormat getByName(String paperFormat) {
        if ("A0".equals(paperFormat)) {
            return PaperFormat.A0;
        } else if ("A1".equals(paperFormat)) {
            return PaperFormat.A1;
        } else if ("A2".equals(paperFormat)) {
            return PaperFormat.A2;
        } else if ("A3".equals(paperFormat)) {
            return PaperFormat.A3;
        } else if ("A4".equals(paperFormat)) {
            return PaperFormat.A4;
        } else {
            return null;
        }
    }
}
