/***********************************************************
 * $Id$
 * 
 * Copyright (C) 2002-2006 ev-i Informationstechnologie GmbH
 *
 * Created: 07.01.2018
 *
 * Author: wpausch/ev-i
 * 
 ***********************************************************/

package at.cdes.api.voc;

public enum ReviewType {
    PARALLELREVIEW (0),
    SERIALREVIEW (1),
    SERIALGRAPHICREVIEW (2),
    EMPTYREVIEW (3),
    PARALLELGRAPHICREVIEW (4),
    SERIALMULTIREALMREVIEW (5);
    
    private final int value;
    
    private ReviewType(int value) {
        this.value = value;
    }
    
    public int getValue() {
        return this.value;
    }
    
    public static ReviewType getByValue(Integer value) {
        if (value == null) {
            return null;
        } else if (value == PARALLELREVIEW.getValue()) {
            return ReviewType.PARALLELREVIEW;
        } else if (value == SERIALREVIEW.getValue()) {
            return ReviewType.SERIALREVIEW;
        } else if (value == SERIALGRAPHICREVIEW.getValue()) {
            return ReviewType.SERIALGRAPHICREVIEW;
        } else if (value == EMPTYREVIEW.getValue()) {
            return ReviewType.EMPTYREVIEW;
        } else if (value == PARALLELGRAPHICREVIEW.getValue()) {
            return ReviewType.PARALLELGRAPHICREVIEW;
        }  else if (value == SERIALMULTIREALMREVIEW.getValue()) {
            return ReviewType.SERIALMULTIREALMREVIEW;
        } else {
            throw new IllegalArgumentException("Unknown DocumentVersionStatusValue [" + value + "] found, please inspect.");
        }
    }    
}
