/***********************************************************
 * $Id$
 * 
 * Copyright (C) 2002-2006 ev-i Informationstechnologie GmbH
 *
 * Created: 22.08.2022
 *
 * Author: wpausch/ev-i
 * 
 ***********************************************************/

package at.cdes.api.review.compositeDto;

import java.util.ArrayList;
import java.util.List;

import at.cdes.api.dto.ReviewCycleNode;
import at.cdes.api.dto.ReviewCycleNodeInstanceReleased;
import at.cdes.api.dto.ReviewCycleNodePositionReleased;

public class ReviewCycleNodeInstanceReleasedInfo {
    
    private ReviewCycleNode node;
    private ReviewCycleNodeInstanceReleased nodeInstanceReleased;
    private List<INodePositionReleasedInfo> nodePositionReleasedInfos;
    private int nonAttachedCount = 0;
    
    // Old at.cdes.bo.data.cycle.node.ReviewCycleNode.isEndNode()
    // Refers to: The corresponding ReviewCyclePositionType has no ReviewCycleResultOptions
    //private boolean endNode;   
    
    // ========== NodeInstanceReleased ====
    
    public void setNodeInstanceReleased(ReviewCycleNodeInstanceReleased nodeInstanceReleased) {
        this.nodeInstanceReleased = nodeInstanceReleased;
    }
    
    public ReviewCycleNodeInstanceReleased getNodeInstanceReleased() {
        return this.nodeInstanceReleased;
    }
    
    public Long getNodeInstanceReleasedId() {
        return this.nodeInstanceReleased.getId();
    }
    
    public Integer getNodeInstanceReleasedDuration() {
        return this.nodeInstanceReleased.getDuration();
    }
    
    public Long getCellInstanceReleasedId() {
        return this.nodeInstanceReleased.getReviewCycleCellInstanceId();
    }
    
    //=============== Node ================
    public void setNode(ReviewCycleNode node) {
        this.node = node;
    }
    
    public Long getNodeId() {
        return this.node.getId();
    }
    
    public String getNodeName() {
        return this.node.getName();
    }
    
    public int getNodePosition() {
        return this.node.getPosition();
    }
    /*
    public boolean isNodeEndNode() {
        return this.endNode;
    } */   
    
    public boolean isNodeFree() {
        return this.node.isFree() != null && this.node.isFree().booleanValue();
    }
    
    // =========== NodePositionReleased =========
    
    public void setNodePositionReleasedInfos(List<? extends INodePositionReleasedInfo> nodePositionReleasedInfos) {
        this.nodePositionReleasedInfos = new ArrayList<INodePositionReleasedInfo>();
        for (INodePositionReleasedInfo nodePositionReleasedInfo : nodePositionReleasedInfos) {
            if (!nodePositionReleasedInfo.isAttached()) {
                this.nonAttachedCount++;
            }
            this.nodePositionReleasedInfos.add(nodePositionReleasedInfo);
        }
    }
    
    public List<INodePositionReleasedInfo> getNodePositionReleasedInfos() {
        return this.nodePositionReleasedInfos;
    }
    
    public boolean hasNodePositionReleasedInfos() {
        return this.nonAttachedCount > 0;
    }
    
    public int getNodePositionReleasedCount() {
        return this.nonAttachedCount;
    }
}
