/***********************************************************
 * $Id$
 * 
 * Copyright (C) 2002-2006 ev-i Informationstechnologie GmbH
 *
 * Created: 28.11.2017
 *
 * Author: wpausch/ev-i
 * 
 ***********************************************************/

package at.cdes.api.voc;

public enum ArchiveFileFormat {
    ARCHIVE_TYPE_ORIGINAL  (0),
    ARCHIVE_TYPE_PDF       (1),
    ARCHIVE_TYPE_BOTH      (2);
    
    private final int value;

    private ArchiveFileFormat(int value) {
        this.value = value;
    }
    
    public int getValue() {
        return this.value;
    }
    
    public static ArchiveFileFormat getByValue(int value) {
        if (value == ARCHIVE_TYPE_ORIGINAL.getValue()) {
            return ARCHIVE_TYPE_ORIGINAL;
        } else if (value == ARCHIVE_TYPE_PDF.getValue()) {
            return ARCHIVE_TYPE_PDF;
        } else if (value == ARCHIVE_TYPE_BOTH.getValue()) {
            return ARCHIVE_TYPE_BOTH;
        } else {
            throw new IllegalArgumentException("Unrecognized ArchiveFileFormat value: [" + value + "]");
        }
    }
}
