/***********************************************************
 * $Id$
 * 
 * Copyright (C) 2002-2006 ev-i Informationstechnologie GmbH
 *
 * Created: 12.01.2015
 *
 * Author: wpausch/ev-i
 * 
 ***********************************************************/

package at.cdes.api.guiService;

import java.util.List;

import at.cdes.api.dto.DocumentNumberPart;
import at.cdes.api.dto.MasterDataSet;
import at.cdes.api.dto.Network;
import at.cdes.api.dto.Project;
import at.cdes.api.job.core.JobSearchModel;
import at.cdes.api.joinDto.JobJoin;
import at.cdes.api.joinDto.ProjectJoin;
import at.cdes.api.masterData.CopyDocumentNumberPartDefaultInfo;
import at.cdes.api.masterData.DocumentTypeEditInfo;
import at.cdes.api.masterData.MasterDataItem;
import at.cdes.api.masterData.MasterDataPageInfo;
import at.cdes.api.network.dto.NetworkInfo;
import at.cdes.api.network.dto.NetworkListSearchInfo;
import at.cdes.api.network.dto.NetworkSearchModel;

public interface NetworkService {
    public List<Network> getAllNetworks();
    
    public Project getProject(Long projectId);
    public ProjectJoin getProjectJoin(Long projectId);
    
    /** Create a new Project.
     *  Attributes code, name, comment, routeName, networkId, status and access 
     *  need to be set by the client, the remaining attributes are set automatically
     *  at server side.
     *  The localisation is currently set to Austria at server side, however 
     *  implementing the corresponding selection at client side would be possible 
     *  as well.
     * 
     * @param project the new Project with fields as described above
     * @param creatorOrganisationPersonId the id of the OrganisationPerson creating
     *                                    the project
     */
    public void createProject(ProjectJoin project, Long creatorOrganisationPersonId);
    
    
    public void updateProject(ProjectJoin project, Long organisationPersonId);
    
    public void makeProjectAdministrator(Long organisationPersonId, Long networkId, Long projectId);
    
    public List<JobJoin> getJobs(JobSearchModel searchModel);
    public JobJoin getPersistentJobJoin(Long organisationPersonId, Long jobId);
    public void destroyJob(Long organisationPersonId,String uuid);
    public void deleteJob(Long organisationPersonId, Long id);
    
    public List<NetworkInfo> getNetworkInfos(Long organisationPersonId, NetworkSearchModel searchModel);
    public NetworkListSearchInfo getNetworkListSearchInfo(Long organisationPersonId);
    public boolean saveName(Long organisationPersonId, Long networkId, String name);
    public void addAdministrator(Long organisationPersonId, Long networkId, Long administratorOrganisationPersonId);
    public void removeAdministrator(Long organisationPersonId, Long networkPersonId);
    
    public void addCycle(Long organisationPersonId, Long networkId, Long cycleId);
    public void removeCycle(Long organisationPersonId, Long networkId, Long cycleId);
    public void addObjectPlannerDefinitionTemplate(Long organisationPersonId, Long networkId, Long templateId);
    public void removeObjectPlannerDefinitionTemplate(Long organisationPersonId, Long networkId, Long templateId);
    
    public boolean createNetwork(Long organisationPersonId, String name, Long maintainerOrganisationId);
    public void deleteNetwork(Long organisationPersonId, Long networkId);
    
    public MasterDataPageInfo getMasterDataPageInfo(Long organisationPersonId, Long networkId);
    public List<DocumentNumberPart> getDocumentNumberParts(Long organisationPersonId, Long groupId);
    
    public void saveDocumentTypes(Long organisationPersonId, Long masterDataSetId, List<MasterDataItem> items);
    public void saveSubProjectTypes(Long organisationPersonId, Long masterDataSetId, List<MasterDataItem> items);
    public void saveObjectTypes(Long organisationPersonId, Long masterDataSetId, List<MasterDataItem> items);
    public void saveDocumentNumberPartGroups(Long organisationPersonId, Long masterDataSetId, List<MasterDataItem> items);
    public void saveStatutoryDuties(Long organisationPersonId, Long networkId, List<MasterDataItem> items);
    public void saveSubjectAreas(Long organisationPersonId, Long networkId, List<MasterDataItem> items);
    public void savePersonInCharges(Long organisationPersonId, Long networkId, List<MasterDataItem> items);
    
    public void createMasterDataSet(Long organisationPersonId, Long networkId, String name, String description);
    public void createNewDefaultMasterDataSet(Long organisationPersonId, Long networkId, String name, String description);
    public MasterDataSet getMasterDataSet(Long organisationPersonId, Long masterDataSetId);    
    public void saveMasterDataSet(Long organisationPersonId, Long masterDataSetId, String name, String description);
    public String deleteMasterDataSet(Long organisationPersonId, Long masterDataSetId);
    public List<Project> getProjectsAssignedToMasterDataSet(Long organisationPersonId, Long masterDataSetId);
    
    public void saveDocumentNumberParts(Long organisationPersonId, Long groupId, List<DocumentNumberPart> parts);
    public CopyDocumentNumberPartDefaultInfo getCopyDocumentNumberPartDefaultInfo(Long organisationPersonId, Long networkId);
    public void insertCopiesOfDefaultNumberPartGroupsIntoNetwork(Long organisationPersonId, Long networkId, Long masterDataSetId, List<Long> documentNumberPartGroupDefaultIds);
    public DocumentTypeEditInfo getDocumentTypeEditInfo(Long organisationPersonId, Long documentTypeId);
    public void saveDocumentTypeSubTypes(Long organisationPersonId, Long documentTypeId, List<MasterDataItem> subTypeItems);
    
    public String triggerExportDocumentTypes(Long organisationPersonId, Long masterDataSetId);
    public String triggerExportSubProjectTypes(Long organisationPersonId, Long masterDataSetId);
    public String triggerExportObjectTypes(Long organisationPersonId, Long masterDataSetId);
    public String triggerExportStatutoryDuties(Long organisationPersonId, Long networkId);
    public String triggerExportSubjectAreas(Long organisationPersonId, Long networkId);
    public String triggerExportPersonInCharges(Long organisationPersonId, Long networkId);
}
