/***********************************************************
 * $Id$
 * 
 * Copyright (C) 2002-2006 ev-i Informationstechnologie GmbH
 *
 * Created: 04.02.2018
 *
 * Author: wpausch/ev-i
 * 
 ***********************************************************/

package at.cdes.api.dto.msp;

/** More or less generic dto for results of msp operations.
 */
public class MspResult {
    
    /** A more or less numeric result code, such as the code in 
     *  <CopyIntoItemsResult>0</CopyIntoItemsResult>.
     *  As I see no guarantee that such codes in Sharepoint are always
     *  numeric, this attribute is of type String.
     */
    private String numericCode;
    
    /** An error code, such as ErrorCode="DestinationInvalid". */
    private String errorCode;
    
    /** An error message */
    private String errorMessage;
    
    /** An url relevant for the msp operation result. */
    private String url;
    
    /** Evaluation at server side, wether the operation was successful.
     *  The details can be found in the other fields. */
    private Boolean success;

    public String getNumericCode() {
        return this.numericCode;
    }

    public void setNumericCode(String numericCode) {
        this.numericCode = numericCode;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Boolean getSuccess() {
        return this.success;
    }

    public void setSuccess(Boolean success) {
        this.success = success;
    }
}
