/* Copyright (C) 2022 ev-i Informationstechnologie GmbH */

package at.cdes.api.ognl;

// the ognl evaluation cannot be rewritten in cdes-dojo-impl without a breaking change because the old implementation passes hibernate dtos directly to the ognl expressions.
public interface OgnlEvaluator {
    public boolean verifyReviewCycleNodeSkippingRule(Long reviewCycleNodeInstanceReleasedId, Long documentVersionId, Long asBuiltContractorOrganisationPersonId);
    public boolean verifyReviewCycleNodeSkippingRuleForDocument(Long reviewCycleNodeInstanceReleasedId, Long documentId, Long asBuiltContractorOrganisationPersonId);
    public boolean evaluateConnection(Long reviewCycleCellResultId, Long reviewCycleCellConnectionId);
    public boolean evaluateConnectionForDojoImpl(Long documentVersionId, 
                                                 Long reviewCycleResultOptionId, 
                                                 Long reviewCycleCellConnectionId);    
}
