package at.cdes.api.sec;

import org.clazzes.util.sec.DomainPrincipal;

import at.cdes.api.dto.Person;
import at.cdes.api.dto.PersonVariables;

public class CdesPrincipal implements DomainPrincipal {
	
	public static final String CDES_DOMAIN = "CDES";
	
	private Person person;
	private PersonVariables personVariables;
	private Boolean suPrincipal;
	private boolean dsgvoChecked = false;
	
	public CdesPrincipal(Person person, PersonVariables personVariables, Boolean suPrincipal) {
		this.person = person;
		this.personVariables = personVariables;
		this.suPrincipal = suPrincipal;
	}
	
	public Long getPersonId() {
	    return this.person.getId();
	}
	
	public PersonVariables getPersonVariables() {
	    return this.personVariables;
	}
	
	public String getUserLocale() {
	    return this.personVariables.getUserLocale();
	}
	
	public String getName() {
		return CDES_DOMAIN + "/" + this.person.getLogin();
	}

	public String getUserName() {
		return this.person.getLogin();
	}

	public String getPrettyName() {
		return this.person.getGivenName() + " " + this.person.getSurName();
	}

	public String getDomain() {
		return CDES_DOMAIN;
	}

	public String getEMailAddress() {
		// email address is a property of OrganisationPerson, not of Person
		return null;
	}
	
	public Boolean isSuPrincipal() {
		return this.suPrincipal != null && this.suPrincipal == true;
	}

    public boolean isDsgvoChecked() {
        return this.dsgvoChecked;
    }

    public void setDsgvoChecked(boolean dsgvoChecked) {
        this.dsgvoChecked = dsgvoChecked;
    }
}
