/***********************************************************
 * $Id$
 * 
 * Copyright (C) 2002-2006 ev-i Informationstechnologie GmbH
 *
 * Created: 04.02.2015
 *
 * Author: wpausch/ev-i
 * 
 ***********************************************************/

package at.cdes.api.compositeDto;

import java.util.List;
import java.util.Map;

import at.cdes.api.dto.DocumentNumberPart;
import at.cdes.api.dto.DocumentNumberPartGroup;
import at.cdes.api.dto.DocumentType;
import at.cdes.api.dto.MasterDataSet;
import at.cdes.api.dto.ObjectType;
import at.cdes.api.dto.SubProjectType;

public class MasterDataInfo {
    
    private MasterDataSet masterDataSet;
    private Map<Long, DocumentNumberPartGroup> groupIdToDocumentNumberGroup;
    private Map<Long, List<DocumentNumberPart>> groupIdToDocumentNumberParts;
    private Map<Long, DocumentType> idToDocumentType;
    private Map<Long, List<DocumentType>> idToDocumentTypeChildren;
    private Map<Long, ObjectType> idToObjectType;
    private Map<Long, SubProjectType> idToSubProjectType;
    
    public MasterDataSet getMasterDataSet() {
        return this.masterDataSet;
    }
    public void setMasterDataSet(MasterDataSet masterDataSet) {
        this.masterDataSet = masterDataSet;
    }
    
    public Map<Long, DocumentNumberPartGroup> getGroupIdToDocumentNumberGroup() {
        return this.groupIdToDocumentNumberGroup;
    }
    public void setGroupIdToDocumentNumberGroup(Map<Long, DocumentNumberPartGroup> groupIdToDocumentNumberGroup) {
        this.groupIdToDocumentNumberGroup = groupIdToDocumentNumberGroup;
    }
    
    public Map<Long, List<DocumentNumberPart>> getGroupIdToDocumentNumberParts() {
        return this.groupIdToDocumentNumberParts;
    }
    public void setGroupIdToDocumentNumberParts(Map<Long, List<DocumentNumberPart>> groupIdToDocumentNumberParts) {
        this.groupIdToDocumentNumberParts = groupIdToDocumentNumberParts;
    }
    
    public Map<Long, DocumentType> getIdToDocumentType() {
        return this.idToDocumentType;
    }
    public void setIdToDocumentType(Map<Long, DocumentType> idToDocumentType) {
        this.idToDocumentType = idToDocumentType;
    }
    
    public Map<Long, List<DocumentType>> getIdToDocumentTypeChildren() {
        return this.idToDocumentTypeChildren;
    }
    public void setIdToDocumentTypeChildren(Map<Long, List<DocumentType>> idToDocumentTypeChildren) {
        this.idToDocumentTypeChildren = idToDocumentTypeChildren;
    }
    
    public Map<Long, ObjectType> getIdToObjectType() {
        return this.idToObjectType;
    }
    public void setIdToObjectType(Map<Long, ObjectType> idToObjectType) {
        this.idToObjectType = idToObjectType;
    }
    
    public Map<Long, SubProjectType> getIdToSubProjectType() {
        return this.idToSubProjectType;
    }
    public void setIdToSubProjectType(Map<Long, SubProjectType> idToSubProjectType) {
        this.idToSubProjectType = idToSubProjectType;
    }
    
    /******************** Utility functions for easier access to data items ************************/
    
    public DocumentType getDocumentType(Long documentTypeId) {
        return this.idToDocumentType.get(documentTypeId);
    }
    
    public ObjectType getObjectType(Long objectTypeId) {
        return this.idToObjectType.get(objectTypeId);
    }
}
