/* Copyright (C) 2022 ev-i Informationstechnologie GmbH */

package at.cdes.api.document.compositeDto;

import at.cdes.api.dto.Document;
import at.cdes.api.dto.DocumentRelease;
import at.cdes.api.dto.DocumentVersion;

public class DocumentOrDocumentRelease {
    private Boolean released;
    private Integer number;
    private String name;
    private String scale;
    private String content;
    private String comment;
    private Boolean hasDocumentVersions;
    private Long documentListId;
    private Long objectPlannerId;
    private Long documentTypeId;
    private Double startDate;
    private Double endDate;
    private Integer duration;
    private Integer modified;

    public DocumentOrDocumentRelease(Document document) {
        this.released = false;
        this.number = document.getNumber();
        this.name = document.getName();
        this.scale = document.getScale();
        this.content = document.getContent();
        this.comment = document.getComment();
        this.hasDocumentVersions = document.getHasDocumentVersions();
        this.documentListId = document.getDocumentListId();
        this.objectPlannerId = document.getObjectPlannerId();
        this.documentTypeId = document.getDocumentTypeId();
        this.startDate = document.getStartDate();
        this.endDate = document.getEndDate();
        this.duration = document.getDuration();
        this.modified = document.getModified();
        this.number = document.getNumber();
    }
    public DocumentOrDocumentRelease(DocumentRelease documentRelease) {
        this.released = true;
        this.number = documentRelease.getNumber();
        this.name = documentRelease.getName();
        this.scale = documentRelease.getScale();
        this.content = documentRelease.getContent();
        this.comment = documentRelease.getComment();
        this.hasDocumentVersions = documentRelease.getHasDocumentVersions();
        this.documentListId = documentRelease.getDocumentListId();
        this.objectPlannerId = documentRelease.getObjectPlannerId();
        this.documentTypeId = documentRelease.getDocumentTypeId();
        this.startDate = documentRelease.getStartDate();
        this.endDate = documentRelease.getEndDate();
        this.duration = documentRelease.getDuration();
        this.modified = documentRelease.getModified();
        this.number = documentRelease.getNumber();
    }
    public Boolean getReleased() {
        return released;
    }
    public void setReleased(Boolean released) {
        this.released = released;
    }
    public Integer getNumber() {
        return number;
    }
    public void setNumber(Integer number) {
        this.number = number;
    }
    public String getName() {
        return name;
    }
    public void setName(String name) {
        this.name = name;
    }
    public String getScale() {
        return scale;
    }
    public void setScale(String scale) {
        this.scale = scale;
    }
    public String getContent() {
        return content;
    }
    public void setContent(String content) {
        this.content = content;
    }
    public String getComment() {
        return comment;
    }
    public void setComment(String comment) {
        this.comment = comment;
    }
    public Boolean getHasDocumentVersions() {
        return hasDocumentVersions;
    }
    public void setHasDocumentVersions(Boolean hasDocumentVersions) {
        this.hasDocumentVersions = hasDocumentVersions;
    }
    public Long getDocumentListId() {
        return documentListId;
    }
    public void setDocumentListId(Long documentListId) {
        this.documentListId = documentListId;
    }
    public Long getObjectPlannerId() {
        return objectPlannerId;
    }
    public void setObjectPlannerId(Long objectPlannerId) {
        this.objectPlannerId = objectPlannerId;
    }
    public Long getDocumentTypeId() {
        return documentTypeId;
    }
    public void setDocumentTypeId(Long documentTypeId) {
        this.documentTypeId = documentTypeId;
    }
    public Double getStartDate() {
        return startDate;
    }
    public void setStartDate(Double startDate) {
        this.startDate = startDate;
    }
    public Double getEndDate() {
        return endDate;
    }
    public void setEndDate(Double endDate) {
        this.endDate = endDate;
    }
    public Integer getDuration() {
        return duration;
    }
    public void setDuration(Integer duration) {
        this.duration = duration;
    }
    public Integer getModified() {
        return modified;
    }
    public void setModified(Integer modified) {
        this.modified = modified;
    }
}
