/***********************************************************
 * $Id$
 * 
 * Copyright (C) 2002-2006 ev-i Informationstechnologie GmbH
 *
 * Created: 26.03.2023
 *
 * Author: wpausch/ev-i
 * 
 ***********************************************************/

package at.cdes.api.debug;

import java.util.ArrayList;
import java.util.List;

public class DebugNode {
    
    private long id;
    private String message;
    private List<DebugNode> childNodes = new ArrayList<DebugNode>();
    
    private static long nextId = 0;
    
    public DebugNode(String message) {
        this.message = message;
        this.id = nextId;
        nextId++;
    }
    
    public long getId() {
        return this.id;
    }
    
    public void appendNode(DebugNode node) {
        this.childNodes.add(node);
    }
    
    public void appendMessage(String newMessage) {
        this.childNodes.add(new DebugNode(newMessage));
    }
    
    public String getMessage() {
        return this.message;
    }
}
