/***********************************************************
 * $Id$
 * 
 * Copyright (C) 2002-2006 ev-i Informationstechnologie GmbH
 *
 * Created: 19.04.2022
 *
 * Author: wpausch/ev-i
 * 
 ***********************************************************/

package at.cdes.api.review.voc;

public enum LabelTextFieldType {
    SIGNATURE ("Signature"),
    DOCUMENT_VERSION ("DocumentVersion"),
    FREE ("Free");
    
    private final String value;

    private LabelTextFieldType(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public static LabelTextFieldType getByValue(String value) {
        if (SIGNATURE.getValue().equals(value)) {
            return SIGNATURE;
        } else if (DOCUMENT_VERSION.getValue().equals(value)) {
            return DOCUMENT_VERSION;
        } else if (FREE.getValue().equals(value)) {
            return FREE;
        } else {
            return null;
        }
    }    

}
