/***********************************************************
 * $Id$
 * 
 * Copyright (C) 2002-2006 ev-i Informationstechnologie GmbH
 *
 * Created: 20.02.2022
 *
 * Author: wpausch/ev-i
 * 
 ***********************************************************/

package at.cdes.api.plot.voc;

public enum PlotScale {
    NONE ("keine"),
    A0 ("A0"),
    A1 ("A1"),
    A2 ("A2"),
    A3 ("A3"),
    A4 ("A4");
    
    private final String value;

    private PlotScale(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public static PlotScale getByValue(String value) {
        if (NONE.getValue().equals(value)) {
            return NONE;
        } else if (A0.getValue().equals(value)) {
            return A0;
        } else if (A1.getValue().equals(value)) {
            return A1;
        } else if (A2.getValue().equals(value)) {
            return A2;
        } else if (A3.getValue().equals(value)) {
            return A3;
        } else if (A4.getValue().equals(value)) {
            return A4;            
        } else {
            return null;
        }
    }
}
