/***********************************************************
 * $Id$
 * 
 * Copyright (C) 2002-2006 ev-i Informationstechnologie GmbH
 *
 * Created: 22.08.2022
 *
 * Author: wpausch/ev-i
 * 
 ***********************************************************/

package at.cdes.api.review.compositeDto;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import at.cdes.api.dto.ReviewCycle;
import at.cdes.api.dto.ReviewCycleCell;
import at.cdes.api.dto.ReviewCycleCellConnection;
import at.cdes.api.dto.ReviewCycleNode;
import at.cdes.api.dto.ReviewCycleResultOption;

public class ReviewCycleInfo {
    
    private Map<Long, ReviewCycle> idToCycle;
    private Map<Long, ReviewCycleCell> idToCell;
    private Map<Long, ReviewCycleNode> idToNode;
    private Set<Long> endNodeIds;
    private Map<Long, List<ReviewCycleCell>> cycleIdToCells;
    private Map<Long, List<ReviewCycleNode>> cellIdToNodes;
    private Map<Long, List<ReviewCycleCellConnection>> cellIdToIncomingConnections;
    private Map<Long, List<ReviewCycleCellConnection>> cellIdToLeavingConnections;
    private Map<Long, ReviewCycleResultOption> idToResultOption;
    
    public void setIdToCycle(Map<Long, ReviewCycle> idToCycle) {
        this.idToCycle = idToCycle;
    }

    public void setIdToCell(Map<Long, ReviewCycleCell> idToCell) {
        this.idToCell = idToCell;
    }

    public void setIdToNode(Map<Long, ReviewCycleNode> idToNode) {
        this.idToNode = idToNode;
    }

    public void setEndNodeIds(Set<Long> endNodeIds) {
        this.endNodeIds = endNodeIds;
    }

    public void setCycleIdToCells(Map<Long, List<ReviewCycleCell>> cycleIdToCells) {
        this.cycleIdToCells = cycleIdToCells;
    }

    public void setCellIdToNodes(Map<Long, List<ReviewCycleNode>> cellIdToNodes) {
        this.cellIdToNodes = cellIdToNodes;
    }
    
    public void setCellIdToLeavingConnections(Map<Long, List<ReviewCycleCellConnection>> cellIdToLeavingConnections) {
        this.cellIdToLeavingConnections = cellIdToLeavingConnections;
    }

    public void setCellIdToIncomingConnections(Map<Long, List<ReviewCycleCellConnection>> cellIdToIncomingConnections) {
        this.cellIdToIncomingConnections = cellIdToIncomingConnections;
    }
    
    public void setResultOptions(List<ReviewCycleResultOption> resultOptions) {
        this.idToResultOption = new HashMap<Long, ReviewCycleResultOption>();
        for (ReviewCycleResultOption resultOption : resultOptions) {
            this.idToResultOption.put(resultOption.getId(), resultOption);
        }
    }
    
    public ReviewCycle getCycleByNodeId(Long nodeId) {
        ReviewCycleNode node = this.idToNode.get(nodeId);
        if (node != null) {
            ReviewCycleCell cell = this.idToCell.get(node.getReviewCycleCellId());
            if (cell != null) {
                ReviewCycle cycle = this.idToCycle.get(cell.getReviewCycleId());
                return cycle;
            } else {
                return null;
            }
        } else {
            return null;
        }
    }
    
    public ReviewCycle getCycleById(Long cycleId) {
        return this.idToCycle.get(cycleId);
    }
    
    public ReviewCycleCell getCellById(Long cellId) {
        return this.idToCell.get(cellId);
    }
    
    public List<ReviewCycleCell> getCellsByCycleId(Long cycleId) {
        return this.cycleIdToCells.containsKey(cycleId) ? this.cycleIdToCells.get(cycleId) : new ArrayList<ReviewCycleCell>();
    }
    
    public ReviewCycleNode getNodeById(Long nodeId) {
        return this.idToNode.get(nodeId);
    }
    
    public List<ReviewCycleNode> getNodesByCellId(Long cellId) {
        return this.cellIdToNodes.containsKey(cellId) ? this.cellIdToNodes.get(cellId) : new ArrayList<ReviewCycleNode>();
    }

    public boolean isNodeEndOfCell(Long nodeId) {
        ReviewCycleNode node = this.idToNode.get(nodeId);
        Long cellId = node.getReviewCycleCellId();
        ReviewCycleCell cell = this.idToCell.get(cellId);
        
        List<ReviewCycleNode> cellNodes = this.cellIdToNodes.containsKey(cellId) ? this.cellIdToNodes.get(cellId) : new ArrayList<ReviewCycleNode>();
        int numberOfNodesOfCell = 0;
        for (ReviewCycleNode cellNode : cellNodes) {
            if (!cellNode.isFree()) {
                numberOfNodesOfCell++;
            }
        }
        
        //int numberOfNodesOfCell = this.cellIdToNodes.containsKey(cellId) ? this.cellIdToNodes.get(cellId).size() : 0;
        int nodesPos = node.getPosition();
        boolean isEndCell = cell.getIsEndCell() != null && cell.getIsEndCell().booleanValue();
        
        return (nodesPos > 0 && ((isEndCell && numberOfNodesOfCell - 1 == nodesPos) 
                         || (!isEndCell && numberOfNodesOfCell == nodesPos )));
    }    
    
    public List<ReviewCycleCellConnection> getIncomingConnectionsForCell(Long cellId) {
        return this.cellIdToIncomingConnections.get(cellId);
    }
    
    public List<ReviewCycleCellConnection> getLeavingConnectionsForCell(Long cellId) {
        return this.cellIdToLeavingConnections.get(cellId);
    }
    
    public boolean isEndNode(Long nodeId) {
        return this.endNodeIds.contains(nodeId);
    }
    
    public String getNodeName(Long nodeId) {
        return this.idToNode.containsKey(nodeId) ? this.idToNode.get(nodeId).getName(): null;
    }
    
    public Long getNodeCellId(Long nodeId) {
        return this.idToNode.containsKey(nodeId) ? this.idToNode.get(nodeId).getReviewCycleCellId() : null;
    }
    
    public ReviewCycleNode getPrevNode(Long nodeId) {
        ReviewCycleNode refNode = this.getNodeById(nodeId);
        int refPos = refNode.getPosition();
        
        List<ReviewCycleNode> cellNodes = this.cellIdToNodes.get(refNode.getReviewCycleCellId());
        ReviewCycleNode chosenNode = null;
        for (ReviewCycleNode cellNode : cellNodes) {
            int candidatePosition = cellNode.getPosition();
            if (candidatePosition < refPos && (chosenNode == null || candidatePosition > chosenNode.getPosition().intValue())) {
                chosenNode = cellNode;
            }
        }
        return chosenNode;
    }
    
    public Long getPrevNodeId(Long nodeId) {
        ReviewCycleNode prevNode = this.getPrevNode(nodeId);
        return prevNode != null ? prevNode.getId() : null;
    }
    
    
    public String getCellName(Long id) {
        return this.idToCell.containsKey(id) ? this.idToCell.get(id).getName() : null;
    }
    
    public Integer getResultOptionValue(Long resultOptionId) {
        return this.idToResultOption.containsKey(resultOptionId) ? this.idToResultOption.get(resultOptionId).getValue() : null;
    }
    
    public String getResultOptionName(Long resultOptionId) {
        return this.idToResultOption.containsKey(resultOptionId) ? this.idToResultOption.get(resultOptionId).getName() : null;
    }
}
