/***********************************************************
 * $Id$
 * 
 * Copyright (C) 2002-2006 ev-i Informationstechnologie GmbH
 *
 * Created: 29.08.2019
 *
 * Author: wpausch/ev-i
 * 
 ***********************************************************/

package at.cdes.api.voc.person;

public enum PersonStatus {
    
    ACTIVE (0),
    MARKED_FOR_DELETION (1),
    INVALID (2);

    private final int value;
    
    private PersonStatus(int value) {
        this.value = value;
    }
    
    public int getValue() {
        return this.value;
    }     
    
    public static PersonStatus getByValue(int value) {
        if (value == ACTIVE.getValue()) {
            return ACTIVE;
        } else if (value == MARKED_FOR_DELETION.getValue()) {
            return MARKED_FOR_DELETION;
        } else if (value == INVALID.getValue()) {
            return INVALID;
        } else {
            throw new IllegalArgumentException("Unrecognized PersonStatus value: [" + value + "]");
        }
    }     
}
