/***********************************************************
 * $Id$
 * 
 * Copyright (C) 2002-2006 ev-i Informationstechnologie GmbH
 *
 * Created: 03.03.2015
 *
 * Author: wpausch/ev-i
 * 
 ***********************************************************/

package at.cdes.api.guiService;

import java.util.List;
import java.util.Map;
import java.util.Set;

import org.clazzes.util.lang.Pair;

import at.cdes.api.dto.OriginalDocumentTask;
import at.cdes.api.result.ResultSummary;
import at.cdes.api.task.dto.ReviewTaskPageInfo;
import at.cdes.api.task.dto.Task;
import at.cdes.api.task.dto.TaskCounts;
import at.cdes.api.task.searchModel.TaskSearchModel;


public interface TaskService {
    
    public void updateReviewTasks(ResultSummary resultSummary, Long projectId, Long subProjectId, List<Long> releasedDocumentIds);
    
    // Apparently not called by anyone
    // public void deleteDocumentVersionTasks(List<Long> taskIds);
    
    public List<Task> getReviewTasks(Long organisationPersonId, TaskSearchModel searchModel);

    public OriginalDocumentTask getOriginalDocumentTaskByTaskId(Long organisationPersonId, Long taskId);
    
    public String triggerExportReviewTaskListPdf(Long loginOrganisationPersonId,
                                                 TaskSearchModel taskSearchModel, 
                                                 Map<String, Double> columnToWidth, 
                                                 List<Pair<String, Boolean>> sortColumns,
                                                 Set<Long> taskIdsAfterQuickFilter,
                                                 String quickFilter);
    
    public String triggerExportReviewTaskListXls(Long loginOrganisationPersonId,
                                                 TaskSearchModel taskSearchModel, 
                                                 Map<String, Double> columnToWidth, 
                                                 List<Pair<String, Boolean>> sortColumns);   
    
    public void deleteTask(Long organisationPersonId, Long taskId);
    
    public TaskCounts getTaskCounts(Long organisationPersonId);
    
    public ReviewTaskPageInfo getReviewTaskPageInfo(Long organisationPersonId);
    
    public int checkTasks(Long organisationPersonId, Long subProjectId);
    
    public int checkAndRestoreTasks(Long organisationPersonId, Long subProjectId);
}
