/***********************************************************
 * $Id$
 * 
 * Copyright (C) 2002-2006 ev-i Informationstechnologie GmbH
 *
 * Created: 08.02.2023
 *
 * Author: wpausch/ev-i
 * 
 ***********************************************************/

package at.cdes.api.obj.dto;

import java.util.List;
import java.util.Map;

import at.cdes.api.dto.ObjectPlanner;
import at.cdes.api.dto.ObjectPlannerPositionDefinition;
import at.cdes.api.dto.ObjectPlannerRelease;
import at.cdes.api.dto.ObjectRelease;
import at.cdes.api.dto.ObjectType;
import at.cdes.api.dto.ReviewCycleInstance;
import at.cdes.api.joinDto.OrganisationPersonSelectionJoin;
import at.cdes.api.joinDto.ParticipationSelectionJoin;

public class ObjectListSearchInfo {
    
    private List<at.cdes.api.dto.Object> objects;
    private List<ObjectPlanner> objectPlanners;
    
    private List<ObjectRelease> objectReleases;
    private List<ObjectPlannerRelease> objectPlannerReleases;
    private List<OrganisationPersonSelectionJoin> opJoins;
    
    
    private List<ParticipationSelectionJoin> plannerSelectionJoins;
    private Map<Long, List<ParticipationSelectionJoin>> roleTypeIdToParticipationSelectionJoin;
    private List<ReviewCycleInstance> reviewCycleInstances;
    private List<ObjectPlannerPositionDefinition> positionDefinitions;
    
    private List<ObjectType> objectTypes;
    private Boolean enableCustomerLogo;
    
    private boolean hasDocumentNumberPart;
    private boolean withObjectType;
    
    private Integer maxObjectCodeLength;
    
    public List<at.cdes.api.dto.Object> getObjects() {
        return this.objects;
    }
    public void setObjects(List<at.cdes.api.dto.Object> objects) {
        this.objects = objects;
    }
    public List<ObjectPlanner> getObjectPlanners() {
        return this.objectPlanners;
    }
    public void setObjectPlanners(List<ObjectPlanner> objectPlanners) {
        this.objectPlanners = objectPlanners;
    }
    public List<ObjectRelease> getObjectReleases() {
        return this.objectReleases;
    }
    public void setObjectReleases(List<ObjectRelease> objectReleases) {
        this.objectReleases = objectReleases;
    }
    public List<ObjectPlannerRelease> getObjectPlannerReleases() {
        return this.objectPlannerReleases;
    }
    public void setObjectPlannerReleases(List<ObjectPlannerRelease> objectPlannerReleases) {
        this.objectPlannerReleases = objectPlannerReleases;
    }
    public List<OrganisationPersonSelectionJoin> getOpJoins() {
        return this.opJoins;
    }
    public void setOpJoins(List<OrganisationPersonSelectionJoin> opJoins) {
        this.opJoins = opJoins;
    }
    
    
    public List<ParticipationSelectionJoin> getPlannerSelectionJoins() {
        return this.plannerSelectionJoins;
    }
    public void setPlannerSelectionJoins(List<ParticipationSelectionJoin> plannerSelectionJoins) {
        this.plannerSelectionJoins = plannerSelectionJoins;
    }
    public Map<Long, List<ParticipationSelectionJoin>> getRoleTypeIdToParticipationSelectionJoin() {
        return this.roleTypeIdToParticipationSelectionJoin;
    }
    public void setRoleTypeIdToParticipationSelectionJoin(Map<Long, List<ParticipationSelectionJoin>> roleTypeIdToParticipationSelectionJoin) {
        this.roleTypeIdToParticipationSelectionJoin =
                roleTypeIdToParticipationSelectionJoin;
    }
    public List<ReviewCycleInstance> getReviewCycleInstances() {
        return this.reviewCycleInstances;
    }
    public void setReviewCycleInstances(List<ReviewCycleInstance> reviewCycleInstances) {
        this.reviewCycleInstances = reviewCycleInstances;
    }
    public List<ObjectPlannerPositionDefinition> getPositionDefinitions() {
        return this.positionDefinitions;
    }
    public void setPositionDefinitions(List<ObjectPlannerPositionDefinition> positionDefinitions) {
        this.positionDefinitions = positionDefinitions;
    }
    
    public List<ObjectType> getObjectTypes() {
        return this.objectTypes;
    }
    public void setObjectTypes(List<ObjectType> objectTypes) {
        this.objectTypes = objectTypes;
    }
    
    public Boolean getEnableCustomerLogo() {
        return this.enableCustomerLogo;
    }
    public void setEnableCustomerLogo(Boolean enableCustomerLogo) {
        this.enableCustomerLogo = enableCustomerLogo;
    }
    public boolean isHasDocumentNumberPart() {
        return this.hasDocumentNumberPart;
    }
    public void setHasDocumentNumberPart(boolean hasDocumentNumberPart) {
        this.hasDocumentNumberPart = hasDocumentNumberPart;
    }
    public boolean isWithObjectType() {
        return this.withObjectType;
    }
    public void setWithObjectType(boolean withObjectType) {
        this.withObjectType = withObjectType;
    }
    public Integer getMaxObjectCodeLength() {
        return this.maxObjectCodeLength;
    }
    public void setMaxObjectCodeLength(Integer maxObjectCodeLength) {
        this.maxObjectCodeLength = maxObjectCodeLength;
    }
}
