/***********************************************************
 * $Id$
 * 
 * Copyright (C) 2002-2006 ev-i Informationstechnologie GmbH
 *
 * Created: 06.04.2023
 *
 * Author: wpausch/ev-i
 * 
 ***********************************************************/

package at.cdes.api.review.compositeDto;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import at.cdes.api.dto.Label;
import at.cdes.api.dto.ObjectList;
import at.cdes.api.dto.PlottOrderTemplate;
import at.cdes.api.dto.ReviewCycle;
import at.cdes.api.dto.ReviewCycleCell;
import at.cdes.api.dto.ReviewCycleInstance;
import at.cdes.api.dto.ReviewCycleNode;
import at.cdes.api.dto.ReviewCycleNodeListener;
import at.cdes.api.dto.ReviewCyclePositionType;
import at.cdes.api.joinDto.ContextJoin;
import at.cdes.api.joinDto.ParticipationSelectionJoin;

public class InstanceInfo {
    
    private ContextJoin contextJoin;
    private ObjectList objectList;
    private List<ReviewCycle> reviewCycles;
    private Map<Long, List<ReviewCycleCell>> cycleIdToCells;
    private Map<Long, List<ReviewCycleNode>> cellIdToNodes;
    private Map<Long, ReviewCyclePositionType> idToPositionType;
    private Map<Long, List<ReviewCycleNodeListener>> nodeIdToListeners;
    private Map<Long, List<Label>> cycleIdToLabels;
    private Boolean reversePreDuration;
    private ReviewCycleInstance instance;
    private ReviewCycle reviewCycle;
    private Label label;
    private boolean hasDocumentVersions;
    private List<CellInstanceInfo> cellInstanceInfos = new ArrayList<CellInstanceInfo>();
    
    private List<ParticipationSelectionJoin> participationSelectionJoins;
    private Map<Long, List<PlottOrderTemplate>> cellIdToPlotOrderTemplates;
    
    private Integer changed;
    private boolean mayChoseRenderLabelOutside;
    
    public ContextJoin getContextJoin() {
        return this.contextJoin;
    }
    public void setContextJoin(ContextJoin contextJoin) {
        this.contextJoin = contextJoin;
    }
    public ObjectList getObjectList() {
        return this.objectList;
    }
    public void setObjectList(ObjectList objectList) {
        this.objectList = objectList;
    }
    public List<ReviewCycle> getReviewCycles() {
        return this.reviewCycles;
    }
    public void setReviewCycles(List<ReviewCycle> reviewCycles) {
        this.reviewCycles = reviewCycles;
    }
    public Map<Long, List<ReviewCycleCell>> getCycleIdToCells() {
        return this.cycleIdToCells;
    }
    public void setCycleIdToCells(Map<Long, List<ReviewCycleCell>> cycleIdToCells) {
        this.cycleIdToCells = cycleIdToCells;
    }
    public Map<Long, List<ReviewCycleNode>> getCellIdToNodes() {
        return this.cellIdToNodes;
    }
    public void setCellIdToNodes(Map<Long, List<ReviewCycleNode>> cellIdToNodes) {
        this.cellIdToNodes = cellIdToNodes;
    }
    public Map<Long, ReviewCyclePositionType> getIdToPositionType() {
        return this.idToPositionType;
    }
    public void setIdToPositionType(Map<Long, ReviewCyclePositionType> idToPositionType) {
        this.idToPositionType = idToPositionType;
    }
    public Map<Long, List<ReviewCycleNodeListener>> getNodeIdToListeners() {
        return this.nodeIdToListeners;
    }
    public void setNodeIdToListeners(Map<Long, List<ReviewCycleNodeListener>> nodeIdToListeners) {
        this.nodeIdToListeners = nodeIdToListeners;
    }
    public Map<Long, List<Label>> getCycleIdToLabels() {
        return this.cycleIdToLabels;
    }
    public void setCycleIdToLabels(Map<Long, List<Label>> cycleIdToLabels) {
        this.cycleIdToLabels = cycleIdToLabels;
    }
    public Boolean getReversePreDuration() {
        return this.reversePreDuration;
    }
    public void setReversePreDuration(Boolean reversePreDuration) {
        this.reversePreDuration = reversePreDuration;
    }
    public ReviewCycleInstance getInstance() {
        return this.instance;
    }
    public void setInstance(ReviewCycleInstance instance) {
        this.instance = instance;
    }
    public ReviewCycle getReviewCycle() {
        return this.reviewCycle;
    }
    public void setReviewCycle(ReviewCycle reviewCycle) {
        this.reviewCycle = reviewCycle;
    }
    public Label getLabel() {
        return this.label;
    }
    public void setLabel(Label label) {
        this.label = label;
    }
    public boolean isHasDocumentVersions() {
        return this.hasDocumentVersions;
    }
    public void setHasDocumentVersions(boolean hasDocumentVersions) {
        this.hasDocumentVersions = hasDocumentVersions;
    }
    public List<CellInstanceInfo> getCellInstanceInfos() {
        return this.cellInstanceInfos;
    }
    public void setCellInstanceInfos(List<CellInstanceInfo> cellInstanceInfos) {
        this.cellInstanceInfos = cellInstanceInfos;
    }
    public void addCellInstanceInfo(CellInstanceInfo cellInstanceInfo) {
        this.cellInstanceInfos.add(cellInstanceInfo);
    }
    public List<ParticipationSelectionJoin> getParticipationSelectionJoins() {
        return this.participationSelectionJoins;
    }
    public void setParticipationSelectionJoins(List<ParticipationSelectionJoin> participationSelectionJoins) {
        this.participationSelectionJoins = participationSelectionJoins;
    }
    public Map<Long, List<PlottOrderTemplate>> getCellIdToPlotOrderTemplates() {
        return this.cellIdToPlotOrderTemplates;
    }
    public void setCellIdToPlotOrderTemplates(Map<Long, List<PlottOrderTemplate>> cellIdToPlotOrderTemplates) {
        this.cellIdToPlotOrderTemplates = cellIdToPlotOrderTemplates;
    }
    public Integer getChanged() {
        return this.changed;
    }
    public void setChanged(Integer changed) {
        this.changed = changed;
    }
	public boolean isMayChoseRenderLabelOutside() {
		return this.mayChoseRenderLabelOutside;
	}
	public void setMayChoseRenderLabelOutside(boolean mayChoseRenderLabelOutside) {
		this.mayChoseRenderLabelOutside = mayChoseRenderLabelOutside;
	}
}
