/***********************************************************
 * $Id$
 * 
 * Copyright (C) 2002-2006 ev-i Informationstechnologie GmbH
 *
 * Created: 13.04.2017
 *
 * Author: wpausch/ev-i
 * 
 ***********************************************************/

package at.cdes.api.guiService;

import java.util.List;

import at.cdes.api.compositeDto.PlanningNotificationReportSearchInfo;
import at.cdes.api.dto.Country;
import at.cdes.api.dto.Search;
import at.cdes.api.dto.util.LocalStorageItem;
import at.cdes.api.joinDto.SearchJoin;

public interface UtilService {
    public String getSafeHtml(String unsafeHtml, boolean simpleText);
    public void printLocalStorageToDebug(List<LocalStorageItem> localStorageItems);
    
    public PlanningNotificationReportSearchInfo getAllOwnSearchJoinsByProject(Long projectId, String pageName);
    public List<SearchJoin> getAllOwnReportSearchesWithForeignByNetwork(Long organisationPersonId, Long networkId, Boolean includeForeign);
    public PlanningNotificationReportSearchInfo getPlanningNotificationReportSearchs(Long organisationPersonId, Long networkId, Boolean includeForeign);
        
    public List<Search> getAllOwnSearchesByNetwork(Long networkId, String pageName);
    public List<Search> getAllOwnSearchesByProject(Long projectId, String pageName);
    public boolean saveOrUpdateSearch(Long organisationPersonId, String pageName, Long projectId, Search search);
    public void deleteSearch(Long organisationPersonId, Long searchId);
    
    public List<Country> getAllCountries(Long organisationPersonId);
}
