/***********************************************************
 * $Id$
 * 
 * Copyright (C) 2002-2006 ev-i Informationstechnologie GmbH
 *
 * Created: 13.02.2018
 *
 * Author: wpausch/ev-i
 * 
 ***********************************************************/

package at.cdes.api.voc.plot;

public enum AcceptedMode {
    
    UNDEFINED (0),
    ACCEPTED (1),
    DECLINED (2);

    private final int value;
    
    private AcceptedMode(int value) {
        this.value = value;
    }
    
    public int getValue() {
        return this.value;
    }         
    
    public static AcceptedMode getByBoolean(Boolean accepted) {
        if (accepted == null) {
            return AcceptedMode.UNDEFINED;
        } else if (accepted.booleanValue()) {
            return AcceptedMode.ACCEPTED;
        } else {
            return AcceptedMode.DECLINED;
        }
    }
    
    public static AcceptedMode getByValue(Integer value) {
        if (value == null) {
            return null;
        } else if (value.intValue() == UNDEFINED.value) {
            return UNDEFINED;
        } else if (value.intValue() == ACCEPTED.value) {
            return ACCEPTED;
        } else if (value.intValue() == DECLINED.value) {
            return DECLINED;
        } else {
            throw new IllegalArgumentException("Unknown value for AcceptedMode: [" + value + "]");
        }
    }
}
