/***********************************************************
 * $Id$
 * 
 * Copyright (C) 2002-2006 ev-i Informationstechnologie GmbH
 *
 * Created: 12.10.2021
 *
 * Author: wpausch/ev-i
 * 
 ***********************************************************/

package at.cdes.api.voc.project;

import at.cdes.api.voc.ProjectStatus;

public enum ProjectAccess {
    
    INVISIBLE (0),
    READ_ONLY (1),
    READ_WRITE (2),
    INVISIBLE_FORNONADMIN (3),
    READ_ONLY_FORNONADMIN (4);

    private final int value;
    
    private ProjectAccess(int value) {
        this.value = value;
    }
    
    public int getValue() {
        return this.value;
    }
    
    public static ProjectAccess fromValue(int value) {
        for (ProjectAccess projectAccess : ProjectAccess.values()) {
            if (projectAccess.getValue() == value) {
                return projectAccess;
            }
        }
        return null;
    }    
}
