/***********************************************************
 * $Id$
 * 
 * Copyright (C) 2002-2006 ev-i Informationstechnologie GmbH
 *
 * Created: 29.08.2019
 *
 * Author: wpausch/ev-i
 * 
 ***********************************************************/

package at.cdes.api.person.compositeDto;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

import at.cdes.api.dto.Network;
import at.cdes.api.dto.Person;
import at.cdes.api.dto.Project;
import at.cdes.api.joinDto.PersonJoin;

public class PersonInfo {
    private Collection<Person> persons;
    
    /** Person <-- OrganisationPerson --> Organisation --> Country */
    private Map<Long, Collection<PersonJoin>> personIdToOrganisationJoins;
    
    /** Person <-- OrganisationPerson <-- ProjectParticipant --> ProjectParticipation --> Project */
    private Map<Long, Collection<Project>> organisationPersonIdToProjects;
    
    /** ProjectParticipation --> CdesRole, and
     *  ProjectParticipation <-- (Main)ProjectParticipant --> (Main)OrganisationPerson --> (Main)Person
     *  ... for the ProjectParticipations stored in personIdToProject, see above.
     *  The project ids used as keys are the ProjectParticipation.projectIds.
     */
    private Map<Long, Map<Long, Collection<PersonJoin>>> organisationPersonIdToProjectIdToRoleJoins;
    
    /** Organisation <-- NetworkOrganisation --> Network 
     *  ... for the Organisations stored in personIdToOrganisationJoins, see above.
     */
    private Map<Long, List<Network>> organisationIdToNetworks;
    
    private Map<Long, Set<String>> networkIdToActions;

    public Collection<Person> getPersons() {
        return this.persons;
    }
    public void setPersons(Collection<Person> persons) {
        this.persons = persons;
    }
    public Map<Long, Collection<PersonJoin>> getPersonIdToOrganisationJoins() {
        return this.personIdToOrganisationJoins;
    }
    public void setPersonIdToOrganisationJoins(Map<Long, Collection<PersonJoin>> personIdToOrganisationJoins) {
        this.personIdToOrganisationJoins = personIdToOrganisationJoins;
    }
    public Map<Long, Collection<Project>> getOrganisationPersonIdToProjects() {
        return this.organisationPersonIdToProjects;
    }
    public void setOrganisationPersonIdToProjects(Map<Long, Collection<Project>> organisationPersonIdToProjects) {
        this.organisationPersonIdToProjects = organisationPersonIdToProjects;
    }
    public Map<Long, Map<Long, Collection<PersonJoin>>> getOrganisationPersonIdToProjectIdToRoleJoins() {
        return this.organisationPersonIdToProjectIdToRoleJoins;
    }
    public void setOrganisationPersonIdToProjectIdToRoleJoins(Map<Long, Map<Long, Collection<PersonJoin>>> organisationPersonIdToProjectIdToRoleJoins) {
        this.organisationPersonIdToProjectIdToRoleJoins = organisationPersonIdToProjectIdToRoleJoins;
    }
    public Map<Long, List<Network>> getOrganisationIdToNetworks() {
        return this.organisationIdToNetworks;
    }
    public void setOrganisationIdToNetworks(Map<Long, List<Network>> organisationIdToNetworks) {
        this.organisationIdToNetworks = organisationIdToNetworks;
    }
    public Map<Long, Set<String>> getNetworkIdToActions() {
        return this.networkIdToActions;
    }
    public void setNetworkIdToActions(Map<Long, Set<String>> networkIdToActions) {
        this.networkIdToActions = networkIdToActions;
    }
}
