/***********************************************************
 * $Id$
 * 
 * Copyright (C) 2002-2006 ev-i Informationstechnologie GmbH
 *
 * Created: 21.08.2022
 *
 * Author: wpausch/ev-i
 * 
 ***********************************************************/

package at.cdes.api.document.compositeDto;

import java.util.List;

import at.cdes.api.dto.DocumentVersion;
import at.cdes.api.dto.ReviewCycleNodeInstance;
import at.cdes.api.voc.DocumentVersionStatus;

public class DocumentListOtherVersionInfo {
    
    private DocumentVersion documentVersion;
    private ReviewCycleNodeInstance activeNodeInstance;
    private List<DocumentListOtherVersionCellResultInfo> cellResultInfos;
    
    public void setDocumentVersion(DocumentVersion documentVersion) {
        this.documentVersion = documentVersion;
    }
    
    public void setActiveNodeInstance(ReviewCycleNodeInstance activeNodeInstance) {
        this.activeNodeInstance = activeNodeInstance;
    }
    
    public void setCellResultInfos(List<DocumentListOtherVersionCellResultInfo> cellResultInfos) {
        this.cellResultInfos = cellResultInfos;
    }
    
    public Long getDocumentVersionId() {
        return this.documentVersion.getId();
    }
    
    public Double getDocumentVersionUploaded() {
        return this.documentVersion.getUploaded();
    }
    
    public DocumentVersionStatus getDocumentVersionStatus() {
        return DocumentVersionStatus.getByValue(this.documentVersion.getStatus());
    }
    
    public Long getDocumentVersionReactivatedVersionId() {
        return this.documentVersion.getReactivatedDocumentVersionId();
    }
    
    public Long getDocumentVersionRevisedVersionId() {
        return this.documentVersion.getRevisedDocumentVersionId();
    }
    
    public Long getActiveNodeInstanceId() {
        return this.activeNodeInstance != null ? this.activeNodeInstance.getId() : null;
    }
    
    public Long getActiveNodeInstanceNodeId() {
        return this.activeNodeInstance != null ? this.activeNodeInstance.getReviewCycleNodeId() : null;
    }
    
    public Integer getActiveNodeInstanceDuration() {
        return this.activeNodeInstance != null ? this.activeNodeInstance.getDuration() : null;
    }
    
    public DocumentListOtherVersionNodeResultInfo getActiveNodeResultInfo() {
        Long activeNodeId = this.getActiveNodeInstanceNodeId();
        for (DocumentListOtherVersionCellResultInfo cellResultInfo : this.cellResultInfos) {
            DocumentListOtherVersionNodeResultInfo nodeResultInfo = cellResultInfo.getNodeResultInfoByNodeId(activeNodeId);
            if (nodeResultInfo != null) {
                return nodeResultInfo;
            }
        }
        return null;
    }
    
    public List<DocumentListOtherVersionCellResultInfo> getCellResultInfos() {
        return this.cellResultInfos;
    }
    
    public int getCellResultCount() {
        return this.cellResultInfos.size();
    }  
    
    public DocumentListOtherVersionCellResultInfo getActualCellResultInfo() {
        // TODO
        return null;
    }
    
    public DocumentListOtherVersionNodeResultInfo getNodeResultInfoByNodeInstanceReleasedId(Long nodeInstanceReleasedId) {
        for (DocumentListOtherVersionCellResultInfo cellResultInfo : this.cellResultInfos) {
            DocumentListOtherVersionNodeResultInfo nodeResultInfo = cellResultInfo.getNodeResultInfoByNodeInstanceReleasedId(nodeInstanceReleasedId);
            if (nodeResultInfo != null) {
                return nodeResultInfo;
            }
        }
        return null;
    }
}
