/***********************************************************
 * $Id$
 * 
 * Copyright (C) 2002-2006 ev-i Informationstechnologie GmbH
 *
 * Created: 22.08.2022
 *
 * Author: wpausch/ev-i
 * 
 ***********************************************************/

package at.cdes.api.review.compositeDto;

import at.cdes.api.dto.Organisation;
import at.cdes.api.dto.Person;
import at.cdes.api.dto.ProjectParticipant;
import at.cdes.api.dto.Realm;
import at.cdes.api.dto.ReviewCycleNodePositionReleased;

public class ReviewCycleNodePositionReleasedInfo implements INodePositionReleasedInfo {
    
    private ReviewCycleNodePositionReleased reviewCycleNodePositionReleased;
    private Realm realm;
    private ProjectParticipant reviewerParticipant;
    private Organisation reviewerOrganisation;
    private Person reviewerMainPerson;
    
    public void setReviewCycleNodePositionReleased(ReviewCycleNodePositionReleased reviewCycleNodePositionReleased) {
        this.reviewCycleNodePositionReleased = reviewCycleNodePositionReleased;
    }
    public void setRealm(Realm realm) {
        this.realm = realm;
    }
    public void setReviewerParticipant(ProjectParticipant reviewerParticipant) {
        this.reviewerParticipant = reviewerParticipant;
    }
    public void setReviewerOrganisation(Organisation reviewerOrganisation) {
        this.reviewerOrganisation = reviewerOrganisation;
    }
    public void setReviewerMainPerson(Person reviewerMainPerson) {
        this.reviewerMainPerson = reviewerMainPerson;
    }
    
    public Long getParticipationId() {
        return this.reviewCycleNodePositionReleased.getProjectParticipationId();        
    }
    
    public Long getRealmId() {
        return this.reviewCycleNodePositionReleased.getRealmId();
    }
    
    public String getRealmName() {
        return this.realm != null && this.realm.getId() != null ? this.realm.getName() : null;
    }
    
    public boolean isAttached() {
        return false;
    }
    
    public boolean isMainParticipant() {
        return this.reviewerParticipant != null && this.reviewerParticipant.getMainParticipantFlag() != null 
                && this.reviewerParticipant.getMainParticipantFlag().booleanValue();
    }
    public String getPersonGivenName() {
        return this.reviewerMainPerson != null ? this.reviewerMainPerson.getGivenName() : null;
    }
    public String getPersonSurName() {
        return this.reviewerMainPerson != null ? this.reviewerMainPerson.getSurName() : null;
    }
    public String getOrganisationName() {
        return this.reviewerOrganisation != null ? this.reviewerOrganisation.getName() : null;
    }
}
