package at.cdes.api.sec;

import java.io.Serializable;
import java.util.Date;

public class PersonVariablesDTO implements Serializable {

	private static final long serialVersionUID = 6200152141039642449L;
	public static final int SCREEN_LARGE = 0;
    public static final int SCREEN_SMALL = 1;
    public static final int TAB_VIEW_MODE_SCHEDULE = 0;
    public static final int TAB_VIEW_MODE_PROXY = 1;
    public static final int TAB_VIEW_MODE_BOTH = 2;
    public static final int PRESELECTED_TAB_ALL = 0;
    public static final int PRESELECTED_TAB_DELAY = 1;
    public static final int PRESELECTED_TAB_TODAY = 2;
    public static final int PRESELECTED_TAB_DISTANT = 3;
    public static final int PRESELECTED_TAB_NODATE = 4;
    public static final int PRESELECTED_TAB_PROXY = 5;
    public static final int PRESELECTED_TAB_MAIN = 6;
    public static final int PRESELECTED_TAB_PN_MAIN = 7;
    
    private Integer id;
	private Integer activeOrganisationPersonId;
	private Integer personId;
	private Date lastlogin;
	private Integer activeNetworkId;
	private Integer activeProjectId;
	private Integer activeSubProjectId;
	private Integer sendMode;
	private int screenSize;
	private int tabViewMode;
	private int preselectedTab;
	private String userLocale;
	private int displayedDaysUntilDue;
	private int displayedDaysOfDoneTasks;
	private boolean memberInMultipleOrganisations;
	private Integer activePNNetworkId;
	private Integer activePNProjectId;
	
	public PersonVariablesDTO() {
	}
	
	public PersonVariablesDTO(Integer id,
								Integer activeOrganisationPersonId,
								Integer personId,
								Date lastlogin,
								Integer activeNetworkId,
								Integer activeProjectId,
								Integer activeSubProjectId,
								Integer sendMode,
								int screenSize,
								int tabViewMode,
								int preselectedTab,
								String userLocale,
								int displayedDaysUntilDue,
								int displayedDaysOfDoneTasks,
								boolean memberInMultipleOrganisations,
								Integer activePNNetworkId,
								Integer activePNProjectId) 
	{
		this.id = id;
		this.activeOrganisationPersonId = activeOrganisationPersonId;
		this.personId = personId;
		this.lastlogin = lastlogin;
		this.activeNetworkId = activeNetworkId;
		this.activeProjectId = activeProjectId;
		this.activeSubProjectId = activeSubProjectId;
		this.sendMode = sendMode;
		this.screenSize = screenSize;
		this.tabViewMode = tabViewMode;
		this.preselectedTab = preselectedTab;
		this.userLocale = userLocale;
		this.displayedDaysUntilDue = displayedDaysUntilDue;
		this.displayedDaysOfDoneTasks = displayedDaysOfDoneTasks;
		this.memberInMultipleOrganisations = memberInMultipleOrganisations;
		this.activePNNetworkId = activePNNetworkId;
		this.activePNProjectId = activePNProjectId;
	}
	
	
	public Integer getId() {
		return id;
	}
	public Integer getActiveOrganisationPersonId() {
		return activeOrganisationPersonId;
	}
	public Date getLastlogin() {
		return lastlogin;
	}
	public Integer getActiveNetworkId() {
		return activeNetworkId;
	}
	public Integer getActiveProjectId() {
		return activeProjectId;
	}
	public Integer getActiveSubProjectId() {
		return activeSubProjectId;
	}
	public Integer getSendMode() {
		return sendMode;
	}
	public int getScreenSize() {
		return screenSize;
	}
	public int getTabViewMode() {
		return tabViewMode;
	}
	public int getPreselectedTab() {
		return preselectedTab;
	}
	public String getUserLocale() {
		return userLocale;
	}
	public int getDisplayedDaysUntilDue() {
		return displayedDaysUntilDue;
	}
	public int getDisplayedDaysOfDoneTasks() {
		return displayedDaysOfDoneTasks;
	}
	public void setId(Integer id) {
		this.id = id;
	}
	public void setActiveOrganisationPersonId(Integer activeOrganisationPersonId) {
		this.activeOrganisationPersonId = activeOrganisationPersonId;
	}
	public void setLastlogin(Date lastlogin) {
		this.lastlogin = lastlogin;
	}
	public void setActiveNetworkId(Integer activeNetworkId) {
		this.activeNetworkId = activeNetworkId;
		setActiveProjectId(null);
	}
	public void setActiveProjectId(Integer activeProjectId) {
		this.activeProjectId = activeProjectId;
		setActiveSubProjectId(null);
	}
	public void setActiveSubProjectId(Integer activeSubProjectId) {
		this.activeSubProjectId = activeSubProjectId;
	}
	public void setSendMode(Integer sendMode) {
		this.sendMode = sendMode;
	}
	public void setScreenSize(int screenSize) {
		this.screenSize = screenSize;
	}
	public void setTabViewMode(int tabViewMode) {
		this.tabViewMode = tabViewMode;
	}
	public void setPreselectedTab(int preselectedTab) {
		this.preselectedTab = preselectedTab;
	}
	public void setUserLocale(String userLocale) {
		this.userLocale = userLocale;
	}
	public void setDisplayedDaysUntilDue(int displayedDaysUntilDue) {
		this.displayedDaysUntilDue = displayedDaysUntilDue;
	}
	public void setDisplayedDaysOfDoneTasks(int displayedDaysOfDoneTasks) {
		this.displayedDaysOfDoneTasks = displayedDaysOfDoneTasks;
	}

	public Integer getPersonId() {
		return personId;
	}

	public void setPersonId(Integer personId) {
		this.personId = personId;
	}

	/**
	 * @return the memberInMultipleOrganisations
	 */
	public boolean isMemberInMultipleOrganisations() {
		return memberInMultipleOrganisations;
	}

	/**
	 * @param memberInMultipleOrganisations the memberInMultipleOrganisations to set
	 */
	public void setMemberInMultipleOrganisations(
			boolean memberInMultipleOrganisations) {
		this.memberInMultipleOrganisations = memberInMultipleOrganisations;
	}

	public Integer getActivePNNetworkId() {
		return activePNNetworkId;
	}

	public void setActivePNNetworkId(Integer activePNNetworkId) {
		this.activePNNetworkId = activePNNetworkId;
		setActivePNProjectId(null);
	}

	public Integer getActivePNProjectId() {
		return activePNProjectId;
	}

	public void setActivePNProjectId(Integer activePNProjectId) {
		this.activePNProjectId = activePNProjectId;
	}
	
}
