/***********************************************************
 * $Id$
 *
 * Copyright (C) 2002-2006 ev-i Informationstechnologie GmbH
 *
 * Created: 05.11.2021
 *
 * Author: wpausch/ev-i
 *
 ***********************************************************/

package at.cdes.api.task.voc;

public enum TaskType {

    ATTACHED_REVIEW_TASK ("AttachedReviewTask"),
    ORIGINAL_DOCUMENT_TASK ("OriginalDocumentTask"),
    PLOT_ORDER_ACCEPTANCE_TASK ("PlotOrderAcceptanceTask"),
    REVIEW_CYCLE_ENTRY_TASK ("ReviewCycleEntryTask"),
    REVIEW_CYCLE_PLOT_TASK ("ReviewCyclePlotTask"),
    REVIEW_TASK ("ReviewTask"),
    SELECT_CELL_CONNECTION_TASK ("SelectCellConnectionTask"),

    ATTACHED_REVIEW_TASK_DONE ("AttachedReviewTaskDone"),
    ORIGINAL_DOCUMENT_TASK_DONE ("OriginalDocumentTaskDone"),
    PLOT_ORDER_ACCEPTANCE_TASK_DONE ("PlotOrderAcceptanceTaskDone"),
    REVIEW_CYCLE_ENTRY_TASK_DONE ("ReviewCycleEntryTaskDone"),
    REVIEW_CYCLE_PLOT_TASK_DONE ("ReviewCyclePlotTaskDone"),
    REVIEW_TASK_DONE ("ReviewTaskDone"),
    SELECT_CELL_CONNECTION_TASK_DONE ("SelectCellConnectionTaskDone"),

    UNKNOWN ("Unknown");

    private final String value;

    private TaskType(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public static TaskType getByValue(String value) {
        if (ATTACHED_REVIEW_TASK.getValue().equals(value)) {
            return ATTACHED_REVIEW_TASK;
        } else if (ORIGINAL_DOCUMENT_TASK.getValue().equals(value)) {
            return ORIGINAL_DOCUMENT_TASK;
        } else if (PLOT_ORDER_ACCEPTANCE_TASK.getValue().equals(value)) {
            return PLOT_ORDER_ACCEPTANCE_TASK;
        } else if (REVIEW_CYCLE_ENTRY_TASK.getValue().equals(value)) {
            return REVIEW_CYCLE_ENTRY_TASK;
        } else if (REVIEW_CYCLE_PLOT_TASK.getValue().equals(value)) {
            return REVIEW_CYCLE_PLOT_TASK;
        } else if (REVIEW_TASK.getValue().equals(value)) {
            return REVIEW_TASK;
        } else if (SELECT_CELL_CONNECTION_TASK.getValue().equals(value)) {
            return SELECT_CELL_CONNECTION_TASK;
        } else {
            return null;
        }
    }
}
