/* Copyright (C) 2022 ev-i Informationstechnologie GmbH */

package at.cdes.api.project.compositeDto;

import java.util.List;

import at.cdes.api.dto.Person;
import at.cdes.api.person.compositeDto.OrganisationPersonInfo;
import at.cdes.api.voc.ProjectStatus;
import at.cdes.api.voc.project.ProjectAccess;

public class ProjectInfo {
    private Long projectId;
    private Long networkId;
    private String networkName;
    private String projectCode;
    private String projectName;
    private Double projectCreated;
    private String projectRouteName;
    private ProjectStatus projectStatus;
    private ProjectAccess projectAccess;
    private List<OrganisationPersonInfo> projectLeaderInfos;
    private List<SubProjectInfo> subProjects;
    private Boolean isProjectAdmin;
    private Person creator;
    
    private boolean mayChangeAccess = false;
    private boolean mayMakeProjectAdmin = false;
    private boolean mayDeleteProject = false;
    private boolean mayEditProject = false;
    private boolean mayShowProject = false;
    private boolean mayShowParticipations = false;
    private boolean mayAddSubProject = false;
    private boolean mayEditSubProject = false;
    private boolean mayDeleteSubProject = false;
    private boolean mayReadWriteSubProject = false;
    
    private boolean mayOpenObjectList = false;
    private boolean mayOpenReviewCycleInstancesOverview = false;
    private boolean mayOpenPlanDeliverCatalogue = false;
    private boolean mayOpenDocumentList = false;
    
    private boolean hasAsBuiltSubProject = false;
    private boolean hasAsBuiltDocuments = false;    

    public String getProjectCode() {
        return projectCode;
    }
    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public Double getProjectCreated() {
        return projectCreated;
    }
    public void setProjectCreated(Double projectCreated) {
        this.projectCreated = projectCreated;
    }
    public String getProjectRouteName() {
        return projectRouteName;
    }
    public void setProjectRouteName(String projectRouteName) {
        this.projectRouteName = projectRouteName;
    }
    public ProjectStatus getProjectStatus() {
        return projectStatus;
    }
    public void setProjectStatus(ProjectStatus projectStatus) {
        this.projectStatus = projectStatus;
    }
    public ProjectAccess getProjectAccess() {
        return this.projectAccess;
    }
    public void setProjectAccess(ProjectAccess projectAccess) {
        this.projectAccess = projectAccess;
    }
    public List<OrganisationPersonInfo> getProjectLeaderInfos() {
        return this.projectLeaderInfos;
    }
    public void setProjectLeaderInfos(List<OrganisationPersonInfo> projectLeaderInfos) {
        this.projectLeaderInfos = projectLeaderInfos;
    }
    public List<SubProjectInfo> getSubProjects() {
        return subProjects;
    }
    public void setSubProjects(List<SubProjectInfo> subProjects) {
        this.subProjects = subProjects;
    }
    public String getProjectName() {
        return projectName;
    }
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getProjectId() {
        return projectId;
    }
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public Boolean getIsProjectAdmin() {
        return this.isProjectAdmin;
    }
    public void setIsProjectAdmin(Boolean isProjectAdmin) {
        this.isProjectAdmin = isProjectAdmin;
    }
    public Long getNetworkId() {
        return networkId;
    }
    public void setNetworkId(Long networkId) {
        this.networkId = networkId;
    }
    public String getNetworkName() {
        return this.networkName;
    }
    public void setNetworkName(String networkName) {
        this.networkName = networkName;
    }
    public Person getCreator() {
        return this.creator;
    }
    public void setCreator(Person creator) {
        this.creator = creator;
    }
    public boolean isMayChangeAccess() {
        return this.mayChangeAccess;
    }
    public void setMayChangeAccess(boolean mayChangeAccess) {
        this.mayChangeAccess = mayChangeAccess;
    }
    public boolean isMayMakeProjectAdmin() {
        return this.mayMakeProjectAdmin;
    }
    public void setMayMakeProjectAdmin(boolean mayMakeProjectAdmin) {
        this.mayMakeProjectAdmin = mayMakeProjectAdmin;
    }
    public boolean isMayDeleteProject() {
        return this.mayDeleteProject;
    }
    public void setMayDeleteProject(boolean mayDeleteProject) {
        this.mayDeleteProject = mayDeleteProject;
    }
    public boolean isMayEditProject() {
        return this.mayEditProject;
    }
    public void setMayEditProject(boolean mayEditProject) {
        this.mayEditProject = mayEditProject;
    }
    public boolean isMayShowProject() {
        return this.mayShowProject;
    }
    public void setMayShowProject(boolean mayShowProject) {
        this.mayShowProject = mayShowProject;
    }
    public boolean isMayShowParticipations() {
        return this.mayShowParticipations;
    }
    public void setMayShowParticipations(boolean mayShowParticipations) {
        this.mayShowParticipations = mayShowParticipations;
    }
    public boolean isMayAddSubProject() {
        return this.mayAddSubProject;
    }
    public void setMayAddSubProject(boolean mayAddSubProject) {
        this.mayAddSubProject = mayAddSubProject;
    }
    public boolean isMayEditSubProject() {
        return this.mayEditSubProject;
    }
    public void setMayEditSubProject(boolean mayEditSubProject) {
        this.mayEditSubProject = mayEditSubProject;
    }
    public boolean isMayDeleteSubProject() {
        return this.mayDeleteSubProject;
    }
    public void setMayDeleteSubProject(boolean mayDeleteSubProject) {
        this.mayDeleteSubProject = mayDeleteSubProject;
    }
    public boolean isMayReadWriteSubProject() {
        return this.mayReadWriteSubProject;
    }
    public void setMayReadWriteSubProject(boolean mayReadWriteSubProject) {
        this.mayReadWriteSubProject = mayReadWriteSubProject;
    }
    
    public boolean isMayOpenObjectList() {
        return this.mayOpenObjectList;
    }
    public void setMayOpenObjectList(boolean mayOpenObjectList) {
        this.mayOpenObjectList = mayOpenObjectList;
    }
    public boolean isMayOpenReviewCycleInstancesOverview() {
        return this.mayOpenReviewCycleInstancesOverview;
    }
    public void setMayOpenReviewCycleInstancesOverview(boolean mayOpenReviewCycleInstancesOverview) {
        this.mayOpenReviewCycleInstancesOverview =
                mayOpenReviewCycleInstancesOverview;
    }
    public boolean isMayOpenPlanDeliverCatalogue() {
        return this.mayOpenPlanDeliverCatalogue;
    }
    public void setMayOpenPlanDeliverCatalogue(boolean mayOpenPlanDeliverCatalogue) {
        this.mayOpenPlanDeliverCatalogue = mayOpenPlanDeliverCatalogue;
    }
    public boolean isMayOpenDocumentList() {
        return this.mayOpenDocumentList;
    }
    public void setMayOpenDocumentList(boolean mayOpenDocumentList) {
        this.mayOpenDocumentList = mayOpenDocumentList;
    }
    public boolean isHasAsBuiltSubProject() {
        return this.hasAsBuiltSubProject;
    }

    public void setHasAsBuiltSubProject(boolean hasAsBuiltSubProject) {
        this.hasAsBuiltSubProject = hasAsBuiltSubProject;
    }

    public boolean isHasAsBuiltDocuments() {
        return this.hasAsBuiltDocuments;
    }

    public void setHasAsBuiltDocuments(boolean hasAsBuiltDocuments) {
        this.hasAsBuiltDocuments = hasAsBuiltDocuments;
    }    
}
